/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class NBTProviderComponent
implements INBTProvider {
    private final INBTProvider provider;
    private List<Field> nbtPersistedFields = null;

    public NBTProviderComponent(INBTProvider provider) {
        this.provider = provider;
        this.generateNBTPersistedFields();
    }

    private void generateNBTPersistedFields() {
        this.nbtPersistedFields = new LinkedList<Field>();
        for (Class<?> clazz = this.provider.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(NBTPersist.class)) continue;
                this.nbtPersistedFields.add(field);
            }
        }
    }

    private void writePersistedField(Field field, ValueOutput output) {
        NBTClassType.performActionForField(this.provider, field, (Either<ValueInput, ValueOutput>)Either.right((Object)output));
    }

    private void readPersistedField(Field field, ValueInput input) {
        NBTClassType.performActionForField(this.provider, field, (Either<ValueInput, ValueOutput>)Either.left((Object)input));
    }

    @Override
    public void writeGeneratedFieldsToNBT(ValueOutput output) {
        for (Field field : this.nbtPersistedFields) {
            this.writePersistedField(field, output);
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(ValueInput input) {
        for (Field field : this.nbtPersistedFields) {
            this.readPersistedField(field, input);
        }
    }
}

