/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.block.BlockSpiritFurnace;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class BlockDarkBloodBrick
extends Block
implements CubeDetector.IDetectionListener {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public BlockDarkBloodBrick(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private void triggerDetector(LevelReader world, BlockPos blockPos, boolean valid) {
        BlockEntitySpiritFurnace.getCubeDetector().detect(world, blockPos, valid ? null : blockPos, true);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide() && !world.captureBlockSnapshots) {
            this.triggerDetector((LevelReader)world, pos, true);
        }
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.isClientSide() && !world.captureBlockSnapshots && blockStateNew.getBlock() != blockStateOld.getBlock()) {
            this.triggerDetector((LevelReader)world, blockPos, true);
        }
    }

    public void destroy(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            this.triggerDetector((LevelReader)world, blockPos, false);
        }
        super.destroy(world, blockPos, blockState);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            boolean change = (Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(world.getBlockState(location), (Property)ACTIVE, (Comparable)Boolean.valueOf(false)) == false;
            ((Level)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
            if (change) {
                BlockEntitySpiritFurnace.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (((Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(blockState, (Property)ACTIVE, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            Wrapper tileLocationWrapper = new Wrapper();
            BlockEntitySpiritFurnace.getCubeDetector().detect((LevelReader)world, blockPos, null, (location, blockState1) -> {
                if (blockState1.getBlock() instanceof BlockSpiritFurnace) {
                    tileLocationWrapper.set(location);
                }
                return null;
            }, false);
            BlockPos tileLocation = (BlockPos)tileLocationWrapper.get();
            if (tileLocation != null) {
                return world.getBlockState(tileLocation).useWithoutItem(world, player, rayTraceResult.withPosition(tileLocation));
            }
        }
        return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
    }
}

