/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;

public class BlockEnvironmentalAccumulator
extends BlockWithEntity {
    public static final MapCodec<BlockEnvironmentalAccumulator> CODEC = BlockEnvironmentalAccumulator.simpleCodec(BlockEnvironmentalAccumulator::new);
    public static final int STATE_IDLE = 0;
    public static final int STATE_PROCESSING_ITEM = 1;
    public static final int STATE_COOLING_DOWN = 2;
    public static final int STATE_FINISHED_PROCESSING_ITEM = 3;

    public BlockEnvironmentalAccumulator(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEnvironmentalAccumulator::new);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockEnvironmentalAccumulator.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENVIRONMENTAL_ACCUMULATOR.get()), (BlockEntityTicker)new BlockEntityEnvironmentalAccumulator.Ticker());
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction direction) {
        return IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)worldIn, pos, BlockEntityEnvironmentalAccumulator.class).map(tile -> tile.getState() == 0 ? 15 : 0).orElse(0);
    }
}

