/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.core.block.IBlockTank;

public class BlockPurifier
extends BlockWithEntity
implements IBlockTank {
    public static final MapCodec<BlockPurifier> CODEC = BlockPurifier.simpleCodec(BlockPurifier::new);
    private static final VoxelShape INSIDE = BlockPurifier.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)BlockPurifier.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockPurifier.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockPurifier.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.ONLY_FIRST);

    public BlockPurifier(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityPurifier::new);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockPurifier.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_PURIFIER.get()), (BlockEntityTicker)new BlockEntityPurifier.Ticker());
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.getInventory().getSelectedItem();
        BlockEntityPurifier tile = (BlockEntityPurifier)world.getBlockEntity(blockPos);
        if (tile != null) {
            if (itemStack.isEmpty() && !tile.getPurifyItem().isEmpty()) {
                player.getInventory().setSelectedItem(tile.getPurifyItem());
                tile.setPurifyItem(ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            if (itemStack.isEmpty() && !tile.getAdditionalItem().isEmpty()) {
                player.getInventory().setSelectedItem(tile.getAdditionalItem());
                tile.setAdditionalItem(ItemStack.EMPTY);
                return InteractionResult.SUCCESS;
            }
            if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)blockPos, (Direction)Direction.UP)) {
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.isEmpty() && tile.getActions().isItemValidForAdditionalSlot(itemStack) && tile.getAdditionalItem().isEmpty()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(1);
                tile.setAdditionalItem(copy);
                itemStack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.isEmpty() && tile.getActions().isItemValidForMainSlot(itemStack) && tile.getPurifyItem().isEmpty()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(1);
                tile.setPurifyItem(copy);
                itemStack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(pStack, pState, world, blockPos, player, hand, pHitResult);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return INSIDE;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos, Direction direction) {
        BlockEntityPurifier tile = (BlockEntityPurifier)world.getBlockEntity(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil((float)IModHelpers.get().getMinecraftHelpers().getComparatorMultiplier() * output);
    }

    @Override
    public int getDefaultCapacity() {
        return IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 3;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Item.TooltipContext context) {
        return false;
    }
}

