/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.block.BlockWithEntityGuiTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;

public class BlockSpiritFurnace
extends BlockWithEntityGuiTank
implements CubeDetector.IDetectionListener {
    public static final MapCodec<BlockSpiritFurnace> CODEC = BlockSpiritFurnace.simpleCodec(BlockSpiritFurnace::new);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public BlockSpiritFurnace(BlockBehaviour.Properties properties) {
        super(properties, BlockEntitySpiritFurnace::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockSpiritFurnace.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SPIRIT_FURNACE.get()), (BlockEntityTicker)(level.isClientSide() ? new BlockEntityTickingTankInventory.TickerClient() : new BlockEntityWorking.TickerServer()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (!BlockEntitySpiritFurnace.canWork(world, blockPos)) {
            return InteractionResult.FAIL;
        }
        return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
    }

    private void triggerDetector(LevelAccessor world, BlockPos blockPos, boolean valid) {
        BlockEntitySpiritFurnace.getCubeDetector().detect((LevelReader)world, blockPos, valid ? null : blockPos, true);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        this.triggerDetector((LevelAccessor)world, pos, true);
    }

    public void onPlace(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.onPlace(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.getBlock() != blockStateOld.getBlock() && !((Boolean)blockStateNew.getValue((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((LevelAccessor)world, blockPos, true);
        }
    }

    public void destroy(LevelAccessor worldIn, BlockPos pos, BlockState state) {
        super.destroy(worldIn, pos, state);
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector(worldIn, pos, false);
        }
    }

    public void onBlockExploded(BlockState state, ServerLevel world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.getBlockState(pos).getValue((Property)ACTIVE)).booleanValue()) {
            this.triggerDetector((LevelAccessor)world, pos, false);
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.wasExploded(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.getBlockState(location).getBlock();
        if (block == this) {
            boolean change = (Boolean)world.getBlockState(location).getValue((Property)ACTIVE) == false;
            ((Level)world).setBlock(location, (BlockState)world.getBlockState(location).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(valid)), IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
            BlockEntity tile = world.getBlockEntity(location);
            if (tile != null) {
                ((BlockEntitySpiritFurnace)tile).setSize(valid ? size : Vec3i.ZERO);
            }
            if (change) {
                BlockEntitySpiritFurnace.detectStructure(world, location, size, valid, originCorner);
            }
        }
    }

    @Override
    public int getDefaultCapacity() {
        return BlockEntitySpiritFurnace.LIQUID_PER_SLOT;
    }
}

