/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.block.component.ParticleDropBlockComponent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockUndeadLeavesConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;

public class BlockUndeadLeaves
extends TintedParticleLeavesBlock {
    private ParticleDropBlockComponent particleDropBlockComponent;

    public BlockUndeadLeaves(BlockBehaviour.Properties properties) {
        super(0.01f, properties);
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            this.particleDropBlockComponent = new ParticleDropBlockComponent(1.0f, 0.0f, 0.0f);
            this.particleDropBlockComponent.setOffset(0);
            this.particleDropBlockComponent.setChance(50);
        }
    }

    public int getLightBlock(BlockState state) {
        return 1;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        this.particleDropBlockComponent.randomDisplayTick(stateIn, worldIn, pos, rand);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return new ItemStack((ItemLike)this);
    }

    protected boolean canFormBloodStains(BlockState state) {
        return BlockUndeadLeavesConfig.maxBloodStainAmount > 0 && (Boolean)state.getValue((Property)PERSISTENT) == false && (Integer)state.getValue((Property)DISTANCE) == 2;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) || this.canFormBloodStains(state);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, worldIn, pos, random);
        if (this.canFormBloodStains(state)) {
            int attempts = 20;
            BlockPos itPos = pos.relative(Direction.DOWN);
            while (attempts-- > 0) {
                if (worldIn.getBlockState(itPos).getBlock() instanceof BlockBloodStain || worldIn.isEmptyBlock(itPos) && ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState().canSurvive((LevelReader)worldIn, itPos)) {
                    BlockState blockState = worldIn.getBlockState(itPos);
                    if (worldIn.isEmptyBlock(itPos)) {
                        blockState = ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState();
                        worldIn.setBlockAndUpdate(itPos, blockState);
                    }
                    if (!(blockState.getBlock() instanceof BlockBloodStain)) break;
                    IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)worldIn, itPos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(1 + worldIn.random.nextInt(BlockUndeadLeavesConfig.maxBloodStainAmount), true));
                    break;
                }
                if (!worldIn.isEmptyBlock(itPos)) break;
                itPos = itPos.relative(Direction.DOWN);
            }
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }
}

