/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntityBloodStain
extends CyclopsBlockEntity {
    public static final int CAPACITY = 5000;
    @NBTPersist
    private Integer amount = 0;

    public BlockEntityBloodStain(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_STAIN.get(), blockPos, blockState);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount, boolean committedChange) {
        this.amount = amount;
        if (this.amount == 0 && committedChange) {
            this.getLevel().removeBlock(this.getBlockPos(), false);
        }
        if (committedChange) {
            this.setChanged();
        }
    }

    public void addAmount(int amount, boolean committedChange) {
        this.setAmount(Math.min(5000, Math.max(0, this.amount + amount)), committedChange);
    }

    public static class FluidHandler
    implements ResourceHandler<FluidResource> {
        private final BlockEntityBloodStain tile;
        private final Journal journal;

        public FluidHandler(BlockEntityBloodStain tile) {
            this.tile = tile;
            this.journal = new Journal();
        }

        public int size() {
            return 1;
        }

        public FluidResource getResource(int tank) {
            return FluidResource.of(RegistryEntries.FLUID_BLOOD);
        }

        public long getAmountAsLong(int tank) {
            return this.tile.getAmount();
        }

        public long getCapacityAsLong(int tank, FluidResource resource) {
            return 5000L;
        }

        public boolean isValid(int tank, FluidResource resource) {
            return tank == 0 && resource.getFluid() == RegistryEntries.FLUID_BLOOD.get();
        }

        public int insert(int tank, FluidResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        public int extract(int tank, FluidResource resource, int amount, TransactionContext transaction) {
            this.journal.updateSnapshots(transaction);
            amount = Math.min(this.tile.getAmount(), amount);
            this.tile.addAmount(-amount, false);
            return amount;
        }

        public class Journal
        extends SnapshotJournal<Integer> {
            protected Integer createSnapshot() {
                return FluidHandler.this.tile.getAmount();
            }

            protected void revertToSnapshot(Integer integer) {
                FluidHandler.this.tile.setAmount(integer, false);
            }

            protected void onRootCommit(Integer originalState) {
                super.onRootCommit((Object)originalState);
                FluidHandler.this.tile.setAmount(originalState, true);
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityBloodStain> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityBloodStain>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.Fluid.BLOCK, (blockEntity, direction) -> new FluidHandler((BlockEntityBloodStain)((Object)blockEntity)));
        }
    }
}

