/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntityEternalWater
extends CyclopsBlockEntity {
    public static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE);

    public BlockEntityEternalWater(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ETERNAL_WATER.get(), blockPos, blockState);
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityEternalWater> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityEternalWater blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            for (Direction direction : Direction.values()) {
                IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(direction), (Object)direction.getOpposite(), Capabilities.Fluid.BLOCK).ifPresent(handler -> {
                    try (Transaction tx = Transaction.openRoot();){
                        handler.insert((Resource)FluidResource.of((FluidStack)WATER), WATER.getAmount(), (TransactionContext)tx);
                        tx.commit();
                    }
                });
            }
        }
    }

    public static class InfiniteWaterFluidCapability
    implements ResourceHandler<FluidResource> {
        public int size() {
            return 1;
        }

        public FluidResource getResource(int tank) {
            return FluidResource.of((FluidStack)WATER);
        }

        public long getAmountAsLong(int tank) {
            return Long.MAX_VALUE;
        }

        public long getCapacityAsLong(int tank, FluidResource resource) {
            return Long.MAX_VALUE;
        }

        public boolean isValid(int tank, FluidResource resource) {
            return false;
        }

        public int insert(int tank, FluidResource resource, int amount, TransactionContext transaction) {
            return 0;
        }

        public int extract(int tank, FluidResource resource, int amount, TransactionContext transaction) {
            return amount;
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityEternalWater> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityEternalWater>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.Fluid.BLOCK, (blockEntity, direction) -> new InfiniteWaterFluidCapability());
        }
    }
}

