/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.InventorySlotMasked;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.VirtualTank;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;

public class BlockEntitySanguinaryEnvironmentalAccumulator
extends BlockEntityWorking<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>
implements VirtualTank.ITankProvider,
MenuProvider {
    public static final int SLOTS = 2;
    public static final int SLOT_ACCUMULATE = 0;
    public static final int SLOT_ACCUMULATE_RESULT = 1;
    public static Metadata METADATA = new Metadata();
    private static final int TANK_CHECK_TICK_OFFSET = 60;
    private int accumulateTicker;
    private SingleCache<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>> recipeCache;
    private VirtualTank virtualTank;
    private boolean forceLoadTanks;
    private List<BlockPos> invalidLocations = Lists.newArrayList();
    private static final Map<Class<?>, ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator>> ACCUMULATE_TICK_ACTIONS = new LinkedHashMap();
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private static final BlockPos[] tankOffsets;

    public BlockEntitySanguinaryEnvironmentalAccumulator(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get(), blockPos, blockState, 2, 64, 0, (Fluid)RegistryEntries.FLUID_BLOOD.get());
        this.accumulateTicker = this.addTicker(new TickComponent<BlockEntitySanguinaryEnvironmentalAccumulator, ITickAction<BlockEntitySanguinaryEnvironmentalAccumulator>>(this, ACCUMULATE_TICK_ACTIONS, 0));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>(this, 2.0){

            @Override
            public void applyUpgrade(BlockEntitySanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt>(this, 1.0){

            @Override
            public void applyUpgrade(BlockEntitySanguinaryEnvironmentalAccumulator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, FluidStack, WeatherType>, Optional<RecipeEnvironmentalAccumulator>>(){

            public Optional<RecipeEnvironmentalAccumulator> getNewValue(Triple<ItemStack, FluidStack, WeatherType> key) {
                Inventory recipeInput = new Inventory(1, 64, BlockEntitySanguinaryEnvironmentalAccumulator.this);
                recipeInput.setItem(0, (ItemStack)key.getLeft());
                return IModHelpers.get().getCraftingHelpers().findRecipe(BlockEntitySanguinaryEnvironmentalAccumulator.this.getRegistry(), (RecipeInput)recipeInput, BlockEntitySanguinaryEnvironmentalAccumulator.this.getLevel()).map(RecipeHolder::value);
            }

            public boolean isKeyEqual(Triple<ItemStack, FluidStack, WeatherType> cacheKey, Triple<ItemStack, FluidStack, WeatherType> newKey) {
                return cacheKey == null || newKey == null || ItemStack.matches((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.isSameFluidSameComponents((FluidStack)((FluidStack)cacheKey.getMiddle()), (FluidStack)((FluidStack)newKey.getMiddle())) && cacheKey.getRight() == newKey.getRight();
            }
        });
        this.virtualTank = new VirtualTank(this, true);
        this.forceLoadTanks = true;
    }

    public List<BlockPos> getInvalidLocations() {
        return this.invalidLocations;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this){

            @Override
            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                if (slot == 0) {
                    return BlockEntitySanguinaryEnvironmentalAccumulator.this.getTileWorkingMetadata().canConsume(itemStack, this.getWorld());
                }
                return super.canPlaceItem(slot, itemStack);
            }
        };
    }

    @Override
    public Inventory getInventory() {
        return (Inventory)super.getInventory();
    }

    public Optional<RecipeEnvironmentalAccumulator> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)new ImmutableTriple((Object)(itemStack.isEmpty() ? ItemStack.EMPTY : itemStack.copy()), (Object)this.getTank().getFluid().copy(), (Object)WeatherType.getActiveWeather(this.level)));
    }

    protected RecipeType<RecipeEnvironmentalAccumulator> getRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get();
    }

    protected void showAccumulatingParticles() {
        BlockEntityEnvironmentalAccumulator.showAccumulatingParticles(this.level, (float)this.getBlockPos().getX() + 0.5f, (float)this.getBlockPos().getY() + 0.5f, (float)this.getBlockPos().getZ() + 0.5f, 25.0f);
    }

    protected void showTankBeams() {
        RandomSource random = this.level.random;
        BlockPos target = this.getBlockPos();
        for (int j = 0; j < tankOffsets.length; ++j) {
            BlockPos offset = tankOffsets[j];
            BlockPos location = target.offset((Vec3i)offset);
            double x = (double)location.getX() + 0.5;
            double y = (double)location.getY() + 0.5;
            double z = (double)location.getZ() + 0.5;
            float rotationYaw = (float)IModHelpers.get().getLocationHelpers().getYaw(location, target);
            float rotationPitch = (float)IModHelpers.get().getLocationHelpers().getPitch(location, target);
            for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                double particleX = x - 0.2 + random.nextDouble() * 0.4;
                double particleY = y - 0.2 + random.nextDouble() * 0.4;
                double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                double speed = 0.5;
                double particleMotionX = (double)(Mth.sin((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.cos((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                double particleMotionY = (double)Mth.cos((float)(rotationPitch / 180.0f * (float)Math.PI)) * -speed;
                double particleMotionZ = (double)(Mth.sin((float)(rotationPitch / 180.0f * (float)Math.PI)) * Mth.sin((float)(rotationYaw / 180.0f * (float)Math.PI))) * speed;
                this.level.addParticle((ParticleOptions)RegistryEntries.PARTICLE_BLOOD_BUBBLE.get(), particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            }
        }
    }

    protected void showMissingTanks() {
        if (this.level.getGameTime() % 10L == 0L) {
            RandomSource random = this.level.random;
            for (BlockPos location : this.invalidLocations) {
                double x = (double)location.getX() + 0.5;
                double y = (double)location.getY() + 0.5;
                double z = (double)location.getZ() + 0.5;
                for (int i = 0; i < 1 + random.nextInt(5); ++i) {
                    double particleX = x - 0.2 + random.nextDouble() * 0.4;
                    double particleY = y - 0.2 + random.nextDouble() * 0.4;
                    double particleZ = z - 0.2 + random.nextDouble() * 0.4;
                    this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void onStateChanged() {
        BlockState blockState = (BlockState)this.level.getBlockState(this.getBlockPos()).setValue((Property)BlockSanguinaryEnvironmentalAccumulator.ON, (Comparable)Boolean.valueOf(this.isWorking()));
        this.level.setBlockAndUpdate(this.getBlockPos(), blockState);
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, IModHelpers.get().getMinecraftHelpers().getBlockNotify() | IModHelpers.get().getMinecraftHelpers().getBlockNotifyClient());
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        if (!(this.forceLoadTanks || this.invalidLocations == null || !this.level.isClientSide() && IModHelpers.get().getWorldHelpers().efficientTick(this.level, 60, this.getBlockPos()))) {
            return this.invalidLocations.isEmpty();
        }
        this.forceLoadTanks = false;
        return this.getVirtualTankChildren() != null;
    }

    @Override
    protected int getWorkTicker() {
        return this.accumulateTicker;
    }

    public VirtualTank getVirtualTank() {
        return this.virtualTank;
    }

    @Override
    @Nullable
    public ResourceHandler<FluidResource>[] getVirtualTankChildren() {
        ResourceHandler[] tanks = new ResourceHandler[tankOffsets.length];
        this.invalidLocations.clear();
        for (int i = 0; i < tankOffsets.length; ++i) {
            BlockPos offset = tankOffsets[i];
            BlockPos location = this.getBlockPos().offset((Vec3i)offset);
            ResourceHandler handler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)this.getLevel(), location, (Object)Direction.UP, Capabilities.Fluid.BLOCK).orElse(null);
            boolean oneValid = false;
            if (handler != null) {
                int tankAmount = handler.size();
                for (int tank = 0; tank < tankAmount; ++tank) {
                    if (((FluidResource)handler.getResource(tank)).isEmpty() || ((FluidResource)handler.getResource(tank)).getFluid() != RegistryEntries.FLUID_BLOOD.get()) continue;
                    oneValid = true;
                    break;
                }
            }
            if (!oneValid) {
                this.invalidLocations.add(location);
            }
            tanks[i] = handler;
        }
        if (!this.invalidLocations.isEmpty()) {
            return null;
        }
        return tanks;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, net.minecraft.world.entity.player.Inventory playerInventory, Player playerEntity) {
        return new ContainerSanguinaryEnvironmentalAccumulator(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.evilcraft.sanguinary_environmental_accumulator");
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        IModHelpers.get().getInventoryHelpers().dropItems(this.level, (Container)this.getInventory(), pos);
    }

    static {
        ACCUMULATE_TICK_ACTIONS.put(Item.class, new AccumulateItemTickAction());
        TICKERS = 1;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        tankOffsets = new BlockPos[]{new BlockPos(-3, 0, -1), new BlockPos(-3, 0, 1), new BlockPos(3, 0, -1), new BlockPos(3, 0, 1), new BlockPos(-1, 0, -3), new BlockPos(-1, 0, 3), new BlockPos(1, 0, -3), new BlockPos(1, 0, 3)};
    }

    public static class Inventory
    extends BlockEntityWorking.Inventory<BlockEntitySanguinaryEnvironmentalAccumulator>
    implements RecipeEnvironmentalAccumulator.Inventory {
        public Inventory(int size, int stackLimit, BlockEntitySanguinaryEnvironmentalAccumulator tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public Level getWorld() {
            return ((BlockEntitySanguinaryEnvironmentalAccumulator)this.tile).getLevel();
        }

        @Override
        public BlockPos getPos() {
            return ((BlockEntitySanguinaryEnvironmentalAccumulator)this.tile).getBlockPos();
        }

        public int size() {
            return this.getContainerSize();
        }
    }

    public static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(2);
        }

        @Override
        public boolean canInsertItem(Container inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            return true;
        }

        @Override
        protected Block getBlock() {
            return (Block)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get();
        }

        public int getConsumeSlot() {
            return 0;
        }

        public int getProduceSlot() {
            return 1;
        }
    }

    public static class TickerClient
    extends BlockEntityTickingTankInventory.TickerClient<BlockEntitySanguinaryEnvironmentalAccumulator> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySanguinaryEnvironmentalAccumulator blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.isVisuallyWorking()) {
                blockEntity.showTankBeams();
                if (blockEntity.getRequiredWorkTicks() - (float)blockEntity.getWorkTick() > 50.0f) {
                    blockEntity.showAccumulatingParticles();
                }
            } else if (!blockEntity.canWork()) {
                blockEntity.showMissingTanks();
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityWorking.CapabilityRegistrar<BlockEntitySanguinaryEnvironmentalAccumulator, MutableInt> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySanguinaryEnvironmentalAccumulator>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.Item.BLOCK, (blockEntity, direction) -> VanillaContainerWrapper.of((Container)new InventorySlotMasked((Container)blockEntity.getInventory(), new int[]{direction == Direction.DOWN ? 1 : 0})));
        }

        @Override
        public void registerTankInventoryCapabilitiesFluid() {
        }
    }
}

