/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodchest;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.api.tileentity.bloodchest.IBloodChestRepairActionRegistry;
import org.cyclops.evilcraft.block.BlockColossalBloodChestConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.helper.MathHelpers;

public class BulkRepairItemTickAction
implements ITickAction<BlockEntityColossalBloodChest> {
    @Override
    public boolean canTick(BlockEntityColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        return tile.canWork() && !tile.getTank().isEmpty() && !itemStack.isEmpty();
    }

    private void drainTank(BlockEntityColossalBloodChest tile, float usageMultiplier, int tick) {
        try (Transaction tx = Transaction.openRoot();){
            tile.getTank().extract((Resource)FluidResource.of((Fluid)tile.getTank().getFluidType()), this.getRequiredFluid(tile, usageMultiplier, tick), (TransactionContext)tx);
            tx.commit();
        }
    }

    protected int getRequiredFluid(BlockEntityColossalBloodChest tile, float usageMultiplier, int tick) {
        MutableFloat drain = new MutableFloat((Number)Math.max(0.05, (double)((float)BlockColossalBloodChestConfig.baseMBPerDamage * usageMultiplier * (1.0f - (float)tile.getEfficiency().intValue() / 210.0f))));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(drain, BlockEntityColossalBloodChest.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue().floatValue(), (int)tile.getLevel().getGameTime() + tick % 100);
    }

    @Override
    public void onTick(BlockEntityColossalBloodChest tile, ItemStack itemStack, int slot, int tick) {
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick) && !tile.getTank().isEmpty() && !itemStack.isEmpty()) {
            itemStack = itemStack.copy();
            IBloodChestRepairActionRegistry actions = (IBloodChestRepairActionRegistry)EvilCraft._instance.getRegistryManager().getRegistry(IBloodChestRepairActionRegistry.class);
            int actionID = actions.canRepair(itemStack, tick);
            if (actionID > -1) {
                float simulateMultiplier = ((Float)actions.repair(itemStack, tile.getLevel().random, actionID, false, true, (HolderLookup.Provider)tile.getLevel().registryAccess()).getLeft()).floatValue();
                if ((float)tile.getTank().getFluidAmount() >= (float)this.getRequiredFluid(tile, simulateMultiplier, tick) * simulateMultiplier) {
                    Boolean slotHistory = tile.getSlotTickHistory().get(slot);
                    if (slotHistory == null || !slotHistory.booleanValue()) {
                        tile.setEfficiency(Math.min(tile.getEfficiency() + 1, 200));
                        tile.getSlotTickHistory().put(slot, true);
                    }
                    Pair<Float, ItemStack> repairResult = actions.repair(itemStack, tile.getLevel().random, actionID, true, true, (HolderLookup.Provider)tile.getLevel().registryAccess());
                    itemStack = (ItemStack)repairResult.getRight();
                    this.drainTank(tile, ((Float)repairResult.getLeft()).floatValue(), tick);
                }
            }
            tile.getInventory().setItem(slot, itemStack);
        }
    }

    @Override
    public float getRequiredTicks(BlockEntityColossalBloodChest tile, int slot, int tick) {
        MutableFloat duration = new MutableFloat((float)BlockColossalBloodChestConfig.ticksPerDamage);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableFloat>(duration, BlockEntityColossalBloodChest.UPGRADEEVENT_SPEED));
        return duration.getValue().floatValue();
    }
}

