/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser;

import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclops.cyclopscore.helper.IFluidHelpersNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.BloodInfuserTickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;

public class FluidContainerItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack)) != null;
    }

    @Override
    public void onTick(BlockEntityBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        int filled;
        ItemStack infuseStack = this.getInfuseStack(tile);
        ItemAccess itemAccessInfuse = this.getInfuseItemAccess(tile).oneByOne();
        ResourceHandler container = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)itemAccessInfuse);
        FluidStack fluidStack = tile.getTank().getFluid().copy();
        MutableInt duration = new MutableInt(100);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, BlockEntityBloodInfuser.UPGRADEEVENT_FILLBLOODPERTICK));
        int minAmount = duration.getValue();
        fluidStack.setAmount(Math.min(minAmount, fluidStack.getAmount()));
        try (Transaction tx = Transaction.openRoot();){
            filled = container.insert((Resource)FluidResource.of((FluidStack)fluidStack), fluidStack.getAmount(), (TransactionContext)tx);
            tx.commit();
        }
        if (filled > 0) {
            tx = Transaction.openRoot();
            try {
                tile.getTank().extract((Resource)FluidResource.of((FluidStack)fluidStack), filled, (TransactionContext)tx);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            tile.getInventory().setItem(tile.getTileWorkingMetadata().getConsumeSlot(), infuseStack);
            if (!IModHelpersNeoForge.get().getFluidHelpers().getFluid(container).isEmpty() && (long)IModHelpersNeoForge.get().getFluidHelpers().getAmount(IModHelpersNeoForge.get().getFluidHelpers().getFluid(container)) == IModHelpersNeoForge.get().getFluidHelpers().getCapacity(container) && this.addToProduceSlot(tile, infuseStack)) {
                tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            }
        } else {
            ItemStack result;
            FluidStack moved = IModHelpersNeoForge.get().getFluidHelpers().move((ResourceHandler)tile.getTank(), container, Integer.MAX_VALUE, null, false, false);
            if (!moved.isEmpty() && this.addToProduceSlot(tile, result = itemAccessInfuse.getResource().toStack(itemAccessInfuse.getAmount()))) {
                tile.getInventory().removeItem(tile.getTileWorkingMetadata().getConsumeSlot(), 1);
            }
        }
    }

    @Override
    public int getUnmodifiedRequiredTicks(BlockEntityBloodInfuser tile, int slot) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, this.getInfuseStack(tile));
    }

    @Override
    public ItemStack willProduceItem(BlockEntityBloodInfuser tile) {
        ItemStack itemStack = tile.getInventory().getItem(tile.getTileWorkingMetadata().getConsumeSlot()).copy();
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemAccess itemAccess = ItemAccess.forStack((ItemStack)itemStack);
        ResourceHandler itemStackHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)itemAccess);
        if (itemStackHandler == null) {
            return ItemStack.EMPTY;
        }
        IFluidHelpersNeoForge fh = IModHelpersNeoForge.get().getFluidHelpers();
        FluidStack moved = fh.move((ResourceHandler)tile.getTank(), itemStackHandler, 100, null, false, true);
        if (moved.isEmpty()) {
            fh.move((ResourceHandler)tile.getTank(), itemStackHandler, 100, null, false, true);
        }
        return itemAccess.getResource().toStack(itemAccess.getAmount());
    }
}

