/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction.spiritreanimator;

import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritReanimatorConfig;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritReanimator;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.helper.MathHelpers;

public class ReanimateTickAction
implements ITickAction<BlockEntitySpiritReanimator> {
    @Override
    public boolean canTick(BlockEntitySpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        return tile.getTank().getFluidAmount() >= this.getRequiredMb(tile, tick) && tile.canWork();
    }

    @Override
    public void onTick(BlockEntitySpiritReanimator tile, ItemStack itemStack, int slot, int tick) {
        try (Transaction tx = Transaction.openRoot();){
            tile.getTank().extract((Resource)FluidResource.of((Fluid)tile.getTank().getFluidType()), this.getRequiredMb(tile, tick), (TransactionContext)tx);
            tx.commit();
        }
        if ((float)tick >= this.getRequiredTicks(tile, slot, tick)) {
            SpawnEggItem spawnEggItem;
            ItemStack spawnEgg = ItemStack.EMPTY;
            EntityType<?> entityType = tile.getEntityType();
            if (entityType != null && (spawnEggItem = SpawnEggItem.byId(entityType)) != null) {
                spawnEgg = new ItemStack((ItemLike)spawnEggItem);
            }
            if (!spawnEgg.isEmpty() && this.addToProduceSlot(tile, spawnEgg)) {
                tile.getInventory().removeItem(2, 1);
            }
            if (BlockSpiritReanimatorConfig.clearBoxContents) {
                itemStack.remove(RegistryEntries.COMPONENT_BOX_PLAYER_ID);
                itemStack.remove(RegistryEntries.COMPONENT_BOX_PLAYER_NAME);
                itemStack.remove(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA);
                tile.getInventory().setItem(1, itemStack);
            }
        }
    }

    protected int getRequiredMb(BlockEntitySpiritReanimator tile, int tick) {
        MutableDouble drain = new MutableDouble((double)BlockSpiritReanimatorConfig.mBPerTick);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, BlockEntitySpiritReanimator.UPGRADEEVENT_BLOODUSAGE));
        return MathHelpers.factorToBursts(drain.getValue(), tick);
    }

    @Override
    public float getRequiredTicks(BlockEntitySpiritReanimator tile, int slot, int tick) {
        MutableDouble drain = new MutableDouble((double)BlockSpiritReanimatorConfig.requiredTicks);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableDouble>(drain, BlockEntitySpiritReanimator.UPGRADEEVENT_SPEED));
        return (int)drain.getValue().doubleValue();
    }

    public boolean addToProduceSlot(BlockEntitySpiritReanimator tile, ItemStack itemStack) {
        return IModHelpers.get().getInventoryHelpers().addToSlot((Container)tile.getInventory(), 3, itemStack);
    }
}

