/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockSpiritFurnace;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritFurnace;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSpiritFurnace;

public class ContainerScreenSpiritFurnace
extends ContainerScreenTileWorking<ContainerSpiritFurnace, BlockEntitySpiritFurnace> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int TANKWIDTH = 16;
    public static final int TANKHEIGHT = 58;
    public static final int TANKX = 176;
    public static final int TANKY = 0;
    public static final int TANKTARGETX = 43;
    public static final int TANKTARGETY = 72;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 102;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSpiritFurnace(ContainerSpiritFurnace container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setTank(16, 58, 176, 0, 43, 72);
        this.setProgress(24, 16, 192, 0, 102, 36);
    }

    @Override
    protected Component getName() {
        return Component.translatable((String)"block.evilcraft.spirit_furnace");
    }

    public ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/spirit_furnace_gui.png");
    }

    private String prettyPrintSize(@Nullable Vec3i size) {
        if (size == null) {
            return "Loading...";
        }
        return size.getX() + "x" + size.getY() + "x" + size.getZ();
    }

    @Override
    protected void drawAdditionalForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String prefix = ((BlockSpiritFurnace)RegistryEntries.BLOCK_SPIRIT_FURNACE.get()).getDescriptionId() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(Component.translatable((String)prefix));
        if (!((ContainerSpiritFurnace)this.getMenu()).hasEntity()) {
            lines.add(Component.translatable((String)(prefix + ".no_entity")));
        } else if (!((ContainerSpiritFurnace)this.getMenu()).isSizeValidForEntity()) {
            lines.add(Component.translatable((String)(prefix + ".content_size"), (Object[])new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.getMenu()).getInnerSize())}));
            lines.add(Component.translatable((String)(prefix + ".required_size"), (Object[])new Object[]{this.prettyPrintSize(((ContainerSpiritFurnace)this.getMenu()).getEntitySize())}));
        } else if (((ContainerSpiritFurnace)this.getMenu()).isForceHalt()) {
            lines.add(Component.translatable((String)(prefix + ".force_halt")));
        } else if (((ContainerSpiritFurnace)this.getMenu()).isCaughtError()) {
            lines.add(Component.translatable((String)(prefix + ".caught_error")));
        }
        if (lines.size() > 1) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getGuiTexture(), 102 + this.offsetX, 36 + this.offsetY, 192.0f, 18.0f, 24, 16, 256, 256);
            if (this.isHovering(102 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, guiGraphics, mouseX -= this.leftPos, mouseY -= this.topPos);
            }
        }
    }
}

