/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;

public class ParticleDarkSmoke
extends SingleQuadParticle {
    public ParticleDarkSmoke(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, boolean entityDead, TextureAtlasSprite sprite) {
        super(world, x, y, z, motionX, motionY, motionZ, sprite);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.quadSize = 1.0f;
        this.alpha = this.random.nextFloat() * 0.3f;
        this.rCol = this.random.nextFloat() * 0.05f + 0.1f;
        this.gCol = this.random.nextFloat() * 0.05f;
        this.bCol = this.random.nextFloat() * 0.05f + 0.1f;
        this.gravity = -0.001f;
        this.lifetime = (int)(10.0f / (this.random.nextFloat() * 0.9f + 0.1f));
        if (entityDead) {
            this.setDeathParticles();
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public float getQuadSize(float p_217561_1_) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + p_217561_1_) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.yd += 0.004;
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)0.96f;
            this.yd *= (double)0.96f;
            this.zd *= (double)0.96f;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
        this.quadSize = (1.0f - (float)this.age / (float)this.lifetime) * 2.0f;
    }

    public void setDeathParticles() {
        this.xd *= 2.0;
        this.yd *= 2.0;
        this.zd *= 2.0;
        this.gravity = 0.5f;
        this.rCol = this.random.nextFloat() * 0.33125f;
        this.gCol = this.random.nextFloat() * 0.022187f;
        this.bCol = this.random.nextFloat() * 0.3945f;
    }
}

