/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.core.blockentity.BlockEntityBeacon;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public abstract class RenderBlockEntityBeacon<T extends BlockEntityBeacon, S extends RenderState>
implements BlockEntityRenderer<T, S> {
    private static final ResourceLocation BEACON_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    public RenderBlockEntityBeacon(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return AABB.INFINITE;
    }

    public void extractRenderState(T blockEntity, S renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        ((RenderState)((Object)renderState)).isBeamActive = ((BlockEntityBeacon)((Object)blockEntity)).isBeamActive();
        ((RenderState)((Object)renderState)).beamColor = ((BlockEntityBeacon)((Object)blockEntity)).getBeamColor();
        ((RenderState)((Object)renderState)).isInnerBeam = this.isInnerBeam(blockEntity);
        ((RenderState)((Object)renderState)).animationTime = blockEntity.getLevel() != null ? (float)Math.floorMod(blockEntity.getLevel().getGameTime(), 40) + partialTick : 0.0f;
    }

    public void submit(S renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        this.submitBeacon(renderState, 1.0f, poseStack, submitNodeCollector);
    }

    protected void submitBeacon(S renderState, float partialTicks, PoseStack matrixStackIn, SubmitNodeCollector submitNodeCollector) {
        if (((RenderState)((Object)renderState)).isBeamActive) {
            Vector4f beamColor = ((RenderState)((Object)renderState)).beamColor;
            BeaconRenderer.submitBeaconBeam((PoseStack)matrixStackIn, (SubmitNodeCollector)submitNodeCollector, (ResourceLocation)BEACON_TEXTURE, (float)partialTicks, (float)((RenderState)((Object)renderState)).animationTime, (int)0, (int)256, (int)IModHelpers.get().getBaseHelpers().RGBToInt((int)(beamColor.x() * 256.0f), (int)(beamColor.y() * 256.0f), (int)(beamColor.z() * 256.0f)), (float)(((RenderState)((Object)renderState)).isInnerBeam ? 0.0f : 0.2f), (float)0.25f);
        }
    }

    protected abstract boolean isInnerBeam(T var1);

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public boolean isBeamActive;
        public Vector4f beamColor;
        public boolean isInnerBeam;
        public float animationTime;
    }
}

