/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.blockentity.BlockEntitySpiritPortal;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class RenderBlockEntitySpiritPortal
implements BlockEntityRenderer<BlockEntitySpiritPortal, RenderState> {
    private static final ResourceLocation PORTALBASE = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/model/portal_bases.png");

    public RenderBlockEntitySpiritPortal(BlockEntityRendererProvider.Context context) {
    }

    public AABB getRenderBoundingBox(BlockEntitySpiritPortal blockEntity) {
        return AABB.INFINITE;
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntitySpiritPortal blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.progress = blockEntity.getProgress();
        renderState.partialTicks = partialTick;
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        float progress = renderState.progress;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        this.renderPortalBase(poseStack, submitNodeCollector, cameraRenderState, progress);
        Random random = new Random();
        long seed = renderState.blockPos.asLong();
        random.setSeed(seed);
        this.renderStar(poseStack, submitNodeCollector, seed, progress, Tesselator.getInstance(), renderState.partialTicks, random);
        poseStack.popPose();
    }

    private void renderStar(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, float rotation, float progress, Tesselator tessellator, float partialTicks, Random random) {
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotation * -0.2f % 360.0f / 2.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation * -0.2f % 360.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation * -0.2f % 360.0f / 2.0f));
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 7.0f;
        float MAX_OPACITY = 40.0f;
        float f2 = progress > 0.8f ? (progress - 0.8f) / 0.2f : 0.0f;
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f + progress * 90.0f));
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.lightning(), (pose, vb) -> {
                vb.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(171, 97, 210, (int)(MAX_OPACITY * (1.0f - f2)));
                vb.addVertex(pose, -0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
                vb.addVertex(pose, 0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
                vb.addVertex(pose, 0.0f, f3, 1.0f * f4).setColor(175, 100, 215, 0);
                vb.addVertex(pose, -0.866f * f4, f3, -0.5f * f4).setColor(175, 100, 215, 0);
            });
            ++i;
        }
    }

    private void renderPortalBase(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, float progress) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)cameraRenderState.orientation);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        this.renderIconForProgress(poseStack, submitNodeCollector, (int)(progress * 100.0f) % 4, progress);
        poseStack.popPose();
    }

    private void renderIconForProgress(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int index, float progress) {
        if (progress > 0.8f) {
            progress -= (progress - 0.8f) * 4.0f;
        }
        float u1 = 0.0625f * (float)index;
        float u2 = 0.0625f * (float)(index + 1);
        float v1 = 0.0f;
        float v2 = 0.0625f;
        poseStack.pushPose();
        poseStack.scale(0.5f * progress, 0.5f * progress, 0.5f * progress);
        poseStack.translate(-0.5f, -0.5f, 0.0f);
        int j = 150;
        int k = 150;
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.text((ResourceLocation)PORTALBASE), (pose, vb) -> {
            vb.addVertex(pose, 0.0f, 1.0f, 0.0f).setColor(0.72f, 0.5f, 0.23f, 0.9f).setUv(u1, v2).setUv2(j, k);
            vb.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u1, v1).setUv2(j, k);
            vb.addVertex(pose, 1.0f, 0.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u2, v1).setUv2(j, k);
            vb.addVertex(pose, 1.0f, 1.0f, 0.0f).setColor(0.72f, 0.5f, 0.83f, 0.9f).setUv(u2, v2).setUv2(j, k);
        });
        poseStack.popPose();
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public float progress;
        public float partialTicks;
    }
}

