/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.MovingBlockRenderState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.client.render.entity.RenderStateVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class RenderVengeanceSpirit
extends EntityRenderer<EntityVengeanceSpirit, RenderStateVengeanceSpirit> {
    private final RenderPlayerSpirit playerRenderer;
    private final Map<GameProfile, GameProfile> checkedProfiles = Maps.newHashMap();

    public RenderVengeanceSpirit(EntityRendererProvider.Context context, EntityVengeanceSpiritConfig config) {
        super(context);
        this.playerRenderer = new RenderPlayerSpirit(context);
    }

    public void submit(RenderStateVengeanceSpirit renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        LivingEntityRenderer render;
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        Mob innerEntity = renderState.spirit.getInnerEntity();
        if (innerEntity != null && renderState.spirit.isVisible() && (render = (LivingEntityRenderer)this.entityRenderDispatcher.renderers.get(innerEntity.getType())) != null && !renderState.spirit.isSwarm()) {
            AvatarRenderState innerRenderState;
            Object object = innerRenderState = renderState.spirit.isPlayer() ? this.getAvatarRenderState(renderState) : (LivingEntityRenderState)render.createRenderState();
            if (!renderState.spirit.isPlayer()) {
                render.extractRenderState((LivingEntity)innerEntity, (LivingEntityRenderState)innerRenderState, 0.0f);
            }
            float uv = renderState.spirit.isFrozen() ? ((float)renderState.spirit.tickCount + renderState.partialTick) * 0.01f : 1.0f;
            try {
                PoseStack poseStackInner = new PoseStack();
                poseStackInner.last().pose().set((Matrix4fc)poseStack.last().pose());
                poseStackInner.last().normal().set((Matrix3fc)poseStack.last().normal());
                if (renderState.spirit.isPlayer()) {
                    AvatarRenderState avatarRenderState = innerRenderState;
                    GameProfile gameProfile = new GameProfile(renderState.spirit.getPlayerUUID(), renderState.spirit.getPlayerName());
                    ResourceLocation resourcelocation = DefaultPlayerSkin.getDefaultTexture();
                    Minecraft minecraft = Minecraft.getInstance();
                    if (!this.checkedProfiles.containsKey(gameProfile)) {
                        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.properties().get((Object)"textures"), null);
                        if (property == null) {
                            Minecraft.getInstance().services().profileResolver().fetchById(gameProfile.id()).ifPresent(newGameProfile -> this.checkedProfiles.put(gameProfile, (GameProfile)newGameProfile));
                        }
                    } else {
                        PlayerSkin skin = (PlayerSkin)minecraft.getSkinManager().createLookup(this.checkedProfiles.get(gameProfile), false).get();
                        resourcelocation = skin.body().texturePath();
                        avatarRenderState.skin = skin;
                    }
                    this.playerRenderer.setPlayerTexture(resourcelocation);
                    Minecraft.getInstance().options.hideGui = true;
                    RenderType renderTypeOverride = RenderType.energySwirl((ResourceLocation)this.playerRenderer.getTextureLocation(innerRenderState), (float)uv, (float)uv);
                    this.playerRenderer.submit((LivingEntityRenderState)avatarRenderState, poseStackInner, new SubmitNodeCollectorRenderTypeOverride(nodeCollector, renderTypeOverride), cameraRenderState);
                    Minecraft.getInstance().options.hideGui = false;
                } else {
                    RenderType renderTypeOverride = RenderType.energySwirl((ResourceLocation)render.getTextureLocation((LivingEntityRenderState)innerRenderState), (float)uv, (float)uv);
                    render.submit((LivingEntityRenderState)innerRenderState, poseStackInner, (SubmitNodeCollector)new SubmitNodeCollectorRenderTypeOverride(nodeCollector, renderTypeOverride), cameraRenderState);
                }
            }
            catch (Exception e) {
                renderState.spirit.setSwarm(true);
                renderState.spirit.setPlayerId("");
            }
        }
    }

    private AvatarRenderState getAvatarRenderState(RenderStateVengeanceSpirit renderState) {
        AvatarRenderState avatarRenderState = new AvatarRenderState();
        avatarRenderState.x = renderState.x;
        avatarRenderState.y = renderState.y;
        avatarRenderState.z = renderState.z;
        avatarRenderState.ageInTicks = renderState.ageInTicks;
        avatarRenderState.boundingBoxWidth = renderState.boundingBoxWidth;
        avatarRenderState.boundingBoxHeight = renderState.boundingBoxHeight;
        avatarRenderState.eyeHeight = renderState.eyeHeight;
        avatarRenderState.distanceToCameraSq = renderState.distanceToCameraSq;
        avatarRenderState.isInvisible = renderState.isInvisible;
        avatarRenderState.isDiscrete = renderState.isDiscrete;
        avatarRenderState.displayFireAnimation = renderState.displayFireAnimation;
        avatarRenderState.passengerOffset = renderState.passengerOffset;
        avatarRenderState.nameTag = renderState.nameTag;
        avatarRenderState.nameTagAttachment = renderState.nameTagAttachment;
        avatarRenderState.leashStates = renderState.leashStates;
        avatarRenderState.partialTick = renderState.partialTick;
        avatarRenderState.bodyRot = renderState.bodyRot;
        avatarRenderState.yRot = renderState.yRot;
        avatarRenderState.xRot = renderState.xRot;
        return avatarRenderState;
    }

    public RenderStateVengeanceSpirit createRenderState() {
        return new RenderStateVengeanceSpirit();
    }

    public void extractRenderState(EntityVengeanceSpirit entity, RenderStateVengeanceSpirit renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.spirit = entity;
        renderState.bodyRot = entity.yBodyRot;
        renderState.yRot = entity.yRotO;
        renderState.xRot = entity.xRotO;
    }

    public static class RenderPlayerSpirit
    extends LivingEntityRenderer<Mob, AvatarRenderState, PlayerModel> {
        private ResourceLocation playerTexture;

        public RenderPlayerSpirit(EntityRendererProvider.Context context) {
            super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
            this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, ArmorModelSet.bake((ArmorModelSet)ModelLayers.PLAYER_ARMOR, (EntityModelSet)context.getModelSet(), p_446041_ -> new PlayerModel(p_446041_, false)), context.getEquipmentRenderer()));
            this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
            this.addLayer((RenderLayer)new ArrowLayer((LivingEntityRenderer)this, context));
            this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache()));
        }

        public void setPlayerTexture(ResourceLocation playerTexture) {
            this.playerTexture = playerTexture;
        }

        public AvatarRenderState createRenderState() {
            return new AvatarRenderState();
        }

        public ResourceLocation getTextureLocation(AvatarRenderState renderState) {
            return this.playerTexture;
        }
    }

    public static class SubmitNodeCollectorRenderTypeOverride
    implements SubmitNodeCollector {
        private final SubmitNodeCollector submitNodeCollector;
        private final RenderType renderTypeOverride;

        public SubmitNodeCollectorRenderTypeOverride(SubmitNodeCollector submitNodeCollector, RenderType renderTypeOverride) {
            this.submitNodeCollector = submitNodeCollector;
            this.renderTypeOverride = renderTypeOverride;
        }

        public void submitHitbox(PoseStack poseStack, EntityRenderState entityRenderState, HitboxesRenderState hitboxesRenderState) {
            this.submitNodeCollector.submitHitbox(poseStack, entityRenderState, hitboxesRenderState);
        }

        public void submitShadow(PoseStack poseStack, float v, List<EntityRenderState.ShadowPiece> list) {
            this.submitNodeCollector.submitShadow(poseStack, v, list);
        }

        public void submitNameTag(PoseStack poseStack, @Nullable Vec3 vec3, int i, Component component, boolean b, int i1, double v, CameraRenderState cameraRenderState) {
            this.submitNodeCollector.submitNameTag(poseStack, vec3, i, component, b, i1, v, cameraRenderState);
        }

        public void submitText(PoseStack poseStack, float v, float v1, FormattedCharSequence formattedCharSequence, boolean b, Font.DisplayMode displayMode, int i, int i1, int i2, int i3) {
            this.submitNodeCollector.submitText(poseStack, v, v1, formattedCharSequence, b, displayMode, i, i1, i2, i3);
        }

        public void submitFlame(PoseStack poseStack, EntityRenderState entityRenderState, Quaternionf quaternionf) {
            this.submitNodeCollector.submitFlame(poseStack, entityRenderState, quaternionf);
        }

        public void submitLeash(PoseStack poseStack, EntityRenderState.LeashState leashState) {
            this.submitNodeCollector.submitLeash(poseStack, leashState);
        }

        public <S> void submitModel(Model<? super S> model, S s, PoseStack poseStack, RenderType renderType, int i, int i1, int i2, @Nullable TextureAtlasSprite textureAtlasSprite, int i3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
            this.submitNodeCollector.submitModel(model, s, poseStack, this.renderTypeOverride, i, i1, i2, textureAtlasSprite, i3, crumblingOverlay);
        }

        public void submitModelPart(ModelPart modelPart, PoseStack poseStack, RenderType renderType, int i, int i1, @Nullable TextureAtlasSprite textureAtlasSprite, boolean b, boolean b1, int i2, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, int i3) {
            this.submitNodeCollector.submitModelPart(modelPart, poseStack, this.renderTypeOverride, i, i1, textureAtlasSprite, b, b1, i2, crumblingOverlay, i3);
        }

        public void submitBlock(PoseStack poseStack, BlockState blockState, int i, int i1, int i2) {
            this.submitNodeCollector.submitBlock(poseStack, blockState, i, i1, i2);
        }

        public void submitMovingBlock(PoseStack poseStack, MovingBlockRenderState movingBlockRenderState) {
            this.submitNodeCollector.submitMovingBlock(poseStack, movingBlockRenderState);
        }

        public void submitBlockModel(PoseStack poseStack, RenderType renderType, BlockStateModel blockStateModel, float v, float v1, float v2, int i, int i1, int i2) {
            this.submitNodeCollector.submitBlockModel(poseStack, this.renderTypeOverride, blockStateModel, v, v1, v2, i, i1, i2);
        }

        public void submitItem(PoseStack poseStack, ItemDisplayContext itemDisplayContext, int i, int i1, int i2, int[] ints, List<BakedQuad> list, RenderType renderType, ItemStackRenderState.FoilType foilType) {
            this.submitNodeCollector.submitItem(poseStack, itemDisplayContext, i, i1, i2, ints, list, this.renderTypeOverride, foilType);
        }

        public void submitCustomGeometry(PoseStack poseStack, RenderType renderType, SubmitNodeCollector.CustomGeometryRenderer customGeometryRenderer) {
            this.submitNodeCollector.submitCustomGeometry(poseStack, this.renderTypeOverride, customGeometryRenderer);
        }

        public void submitParticleGroup(SubmitNodeCollector.ParticleGroupRenderer particleGroupRenderer) {
            this.submitNodeCollector.submitParticleGroup(particleGroupRenderer);
        }

        public OrderedSubmitNodeCollector order(int i) {
            return this.submitNodeCollector.order(i);
        }
    }
}

