/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.client.render.model.ModelBoxOfEternalClosureBaked;
import org.jetbrains.annotations.Nullable;

public record ItemModelBoxOfEternalClosure(ModelBoxOfEternalClosureBaked model, ModelRenderProperties modelRenderProperties) implements ItemModel
{
    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable ItemOwner entity, int seed) {
        new BlockModelWrapper(List.of(), this.model.handleItemState(stack, (Level)level, entity), this.modelRenderProperties).update(renderState, stack, itemModelResolver, displayContext, level, entity, seed);
    }

    public record Unbaked(ResourceLocation box, ResourceLocation boxLid, ResourceLocation boxLidRotated) implements ItemModel.Unbaked
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"box_of_eternal_closure");
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("box").forGetter(Unbaked::box), (App)ResourceLocation.CODEC.fieldOf("box_lid").forGetter(Unbaked::boxLid), (App)ResourceLocation.CODEC.fieldOf("box_lid_rotated").forGetter(Unbaked::boxLidRotated)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            ModelBaker baker = bakingContext.blockModelBaker();
            ResolvedModel resolvedModel = baker.getModel(this.box);
            TextureSlots textureslots = resolvedModel.getTopTextureSlots();
            ModelRenderProperties modelRenderProperties = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)resolvedModel, (TextureSlots)textureslots);
            return new ItemModelBoxOfEternalClosure(this.bakeBoxModel(baker, (ModelState)BlockModelRotation.X0_Y180), modelRenderProperties);
        }

        public ModelBoxOfEternalClosureBaked bakeBoxModel(ModelBaker baker, ModelState modelState) {
            return new ModelBoxOfEternalClosureBaked(ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.box, (ModelState)modelState), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.boxLid, (ModelState)modelState), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)this.boxLidRotated, (ModelState)modelState), false);
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.box);
            resolver.markDependency(this.boxLid);
            resolver.markDependency(this.boxLidRotated);
        }
    }
}

