/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.blockentity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.item.WorldlyContainerWrapper;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class BlockEntityTankInventory
extends CyclopsBlockEntity {
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    protected final int tankSize;

    public BlockEntityTankInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize, int tankSize, @Nullable Fluid acceptedFluid) {
        super(type, blockPos, blockState);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.tank = this.createTank(tankSize);
        this.tankSize = tankSize;
        if (acceptedFluid != null) {
            this.tank.setAcceptedFluid(acceptedFluid);
        }
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    protected SingleUseTank createTank(int tankSize) {
        return new SingleUseTank(tankSize);
    }

    public void read(ValueInput valueInput) {
        super.read(valueInput);
        this.inventory.readFromNBT(valueInput, "inventory");
        this.tank.deserialize(valueInput, "tank");
    }

    public void saveAdditional(ValueOutput valueOutput) {
        this.inventory.writeToNBT(valueOutput, "inventory");
        this.tank.serialize(valueOutput, "tank");
        super.saveAdditional(valueOutput);
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void onTankChanged() {
        this.setChanged();
        this.getInventory().setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        IModHelpers.get().getInventoryHelpers().dropItems(this.level, (Container)this.getInventory(), pos);
    }

    public static class CapabilityRegistrar<T extends BlockEntityTankInventory>
    extends BlockEntityCapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.registerTankInventoryCapabilitiesItem();
            this.registerTankInventoryCapabilitiesFluid();
        }

        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.Item.BLOCK, (blockEntity, direction) -> new WorldlyContainerWrapper((WorldlyContainer)blockEntity.getInventory(), direction));
        }

        public void registerTankInventoryCapabilitiesFluid() {
            this.add(Capabilities.Fluid.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
        }
    }
}

