/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import javax.annotation.Nullable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class VirtualTank
implements ResourceHandler<FluidResource> {
    private final ITankProvider tankProvider;
    private final boolean spreadEvenly;

    public VirtualTank(ITankProvider tankProvider, boolean spreadEvenly) {
        this.tankProvider = tankProvider;
        this.spreadEvenly = spreadEvenly;
    }

    protected ResourceHandler<FluidResource>[] getTanks() {
        ResourceHandler<FluidResource>[] tanks = this.tankProvider.getVirtualTankChildren();
        if (tanks == null) {
            tanks = new ResourceHandler[]{};
        }
        return tanks;
    }

    public FluidStack getFluid() {
        if (this.isSpreadEvenly()) {
            FluidStack minFluid = FluidStack.EMPTY;
            int min = Integer.MAX_VALUE;
            for (ResourceHandler<FluidResource> tank : this.getTanks()) {
                int tanks = tank.size();
                for (int i = 0; i < tanks; ++i) {
                    FluidStack tankFluid = ((FluidResource)tank.getResource(i)).toStack(tank.getAmountAsInt(i));
                    if (tankFluid.isEmpty() || tankFluid.getAmount() >= min) continue;
                    min = tankFluid.getAmount();
                    minFluid = tankFluid;
                }
            }
            return minFluid.isEmpty() ? FluidStack.EMPTY : new FluidStack(minFluid.getFluid(), min * this.getTanks().length);
        }
        FluidStack total = FluidStack.EMPTY;
        for (ResourceHandler<FluidResource> tank : this.getTanks()) {
            int tanks = tank.size();
            for (int i = 0; i < tanks; ++i) {
                FluidStack tankFluid = ((FluidResource)tank.getResource(i)).toStack(tank.getAmountAsInt(i));
                if (tankFluid.isEmpty()) continue;
                if (total.isEmpty()) {
                    total = tankFluid.copy();
                    continue;
                }
                if (total.getFluid() != tankFluid.getFluid()) continue;
                total = new FluidStack(total.getFluid(), total.getAmount() + tankFluid.getAmount());
            }
        }
        return total;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int index) {
        return FluidResource.of((FluidStack)this.getFluid());
    }

    public long getAmountAsLong(int i) {
        return this.getFluid().getAmount();
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        long total = 0L;
        for (ResourceHandler<FluidResource> tank : this.getTanks()) {
            int tanks = tank.size();
            for (int i = 0; i < tanks; ++i) {
                total += tank.getCapacityAsLong(i, (Resource)FluidResource.EMPTY);
            }
        }
        return total;
    }

    public boolean isValid(int index, FluidResource resource) {
        return true;
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        int toFill = amount;
        int totalFilled = 0;
        int tanks = this.getTanks().length;
        ResourceHandler<FluidResource>[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            ResourceHandler<FluidResource> tank = tanksArray[i];
            if (this.isSpreadEvenly()) {
                toFill = amount / tanks + (i <= amount % tanks ? 1 : 0);
            }
            int filled = tank.insert((Resource)resource, toFill, transaction);
            toFill -= filled;
            if ((totalFilled += filled) != amount) continue;
            return totalFilled;
        }
        return totalFilled;
    }

    protected boolean isSpreadEvenly() {
        return this.spreadEvenly;
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        int toDrain = amount;
        int totalDrained = 0;
        int tanks = this.getTanks().length;
        ResourceHandler<FluidResource>[] tanksArray = this.getTanks();
        for (int i = 0; i < tanks; ++i) {
            ResourceHandler<FluidResource> tank;
            int drained;
            if (this.isSpreadEvenly()) {
                toDrain = amount / tanks + (i <= amount % tanks ? 1 : 0);
            }
            if ((drained = (tank = tanksArray[i]).extract((Resource)resource, toDrain, transaction)) <= 0) continue;
            toDrain -= drained;
            if ((totalDrained += drained) != amount) continue;
            return totalDrained;
        }
        return totalDrained;
    }

    public static interface ITankProvider {
        @Nullable
        public ResourceHandler<FluidResource>[] getVirtualTankChildren();
    }
}

