/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.TriState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;

public class BlockTankHelpers {
    private BlockTankHelpers() {
    }

    public static MutableComponent getInfoTank(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)itemStack);
        int amount = fluidStack.getAmount();
        int capacity = Optional.ofNullable((ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack))).map(handler -> handler.getCapacityAsInt(0, (Resource)FluidResource.EMPTY)).orElse(0);
        return DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity).withStyle(IInformationProvider.ITEM_PREFIX);
    }

    public static ItemStack tileDataToItemStack(BlockEntity tile, ItemStack itemStack) {
        ResourceHandler fluidHandlerTile = (ResourceHandler)tile.getLevel().getCapability(Capabilities.Fluid.BLOCK, tile.getBlockPos(), null, tile, null);
        if (fluidHandlerTile != null) {
            ResourceHandler fluidHandlerItem;
            ItemAccess itemStackItemAccess = ItemAccess.forStack((ItemStack)itemStack);
            IFluidHandlerCapacity fluidHandlerItemCapacity = (IFluidHandlerCapacity)itemStack.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY, (Object)itemStackItemAccess);
            if (fluidHandlerItemCapacity != null && fluidHandlerTile instanceof IFluidHandlerCapacity) {
                IFluidHandlerCapacity fluidHandlerCapacity = (IFluidHandlerCapacity)fluidHandlerTile;
                fluidHandlerCapacity.setTankCapacity(0, fluidHandlerItemCapacity.getTankCapacity(0));
            }
            if ((fluidHandlerItem = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)itemStackItemAccess)) != null) {
                IModHelpersNeoForge.get().getFluidHelpers().move(fluidHandlerTile, fluidHandlerItem, Integer.MAX_VALUE, null, false, false);
            }
            return itemStackItemAccess.getResource().toStack(itemStackItemAccess.getAmount());
        }
        return itemStack;
    }

    public static void itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        ResourceHandler fluidHandlerTile = (ResourceHandler)tile.getLevel().getCapability(Capabilities.Fluid.BLOCK, tile.getBlockPos(), null, tile, null);
        if (fluidHandlerTile != null) {
            ResourceHandler fluidHandlerItem;
            IFluidHandlerCapacity fluidHandlerItemCapacity = (IFluidHandlerCapacity)itemStack.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY, (Object)ItemAccess.forStack((ItemStack)itemStack));
            if (fluidHandlerItemCapacity != null && fluidHandlerTile instanceof IFluidHandlerCapacity) {
                IFluidHandlerCapacity fluidHandlerCapacity = (IFluidHandlerCapacity)fluidHandlerTile;
                fluidHandlerCapacity.setTankCapacity(0, fluidHandlerItemCapacity.getTankCapacity(0));
            }
            if ((fluidHandlerItem = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack))) != null) {
                IModHelpersNeoForge.get().getFluidHelpers().move(fluidHandlerItem, fluidHandlerTile, Integer.MAX_VALUE, null, false, false);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().isEmpty() && event.getItemStack().getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)event.getItemStack())) != null && event.getLevel().getBlockState(event.getPos()).getBlock() instanceof IBlockTank) {
            event.setUseBlock(TriState.TRUE);
        }
    }

    static {
        NeoForge.EVENT_BUS.register((Object)new BlockTankHelpers());
    }
}

