/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.ItemAccessItemLocation;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemBloodContainer
extends DamageIndicatedItemFluidContainer {
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    public ItemBloodContainer(Item.Properties builder, int capacity) {
        super(builder, capacity, () -> RegistryEntries.FLUID_BLOOD.get());
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        int drained;
        ItemStack itemStack = player.getItemInHand(hand);
        IFluidHandlerCapacity fluidHandler = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(ItemAccess.forStack((ItemStack)itemStack)).orElse(null);
        FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)itemStack);
        try (Transaction tx = Transaction.openRoot();){
            drained = fluidHandler.extract((Resource)FluidResource.of((FluidStack)fluidStack), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), (TransactionContext)tx);
        }
        boolean hasBucket = drained == IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
        boolean hasSpace = fluidStack.isEmpty() || fluidStack.getAmount() + IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() <= fluidHandler.getTankCapacity(0);
        BlockHitResult movingobjectpositionDrain = ItemBloodContainer.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockHitResult movingobjectpositionFill = ItemBloodContainer.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            BlockState blockState;
            if (this.isPickupFluids() && movingobjectpositionFill.getType() == HitResult.Type.BLOCK && (blockState = world.getBlockState(blockPos = movingobjectpositionFill.getBlockPos())).getBlock() instanceof LiquidBlock && ((LiquidBlock)blockState.getBlock()).fluid == this.getFluid() && (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) == 0) {
                if (hasSpace) {
                    world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                    try (Transaction tx = Transaction.openRoot();){
                        fluidHandler.insert((Resource)FluidResource.of((Fluid)this.getFluid()), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), (TransactionContext)tx);
                        tx.commit();
                    }
                }
                return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.getType() == HitResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.getBlockPos();
                Direction direction = movingobjectpositionDrain.getDirection();
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.offset(direction.getUnitVec3i()), true)) {
                    try (Transaction tx = Transaction.openRoot();){
                        fluidHandler.extract((Resource)FluidResource.of((FluidStack)fluidStack), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), (TransactionContext)tx);
                        tx.commit();
                    }
                    return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
                }
            }
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    private boolean tryPlaceContainedLiquid(Level world, BlockPos blockPos, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        BlockState blockState = world.getBlockState(blockPos);
        if (!world.isEmptyBlock(blockPos) && blockState.isSolid()) {
            return false;
        }
        if (!(world.isClientSide() || blockState.isSolid() || blockState.liquid())) {
            world.destroyBlock(blockPos, true);
        }
        world.setBlock(blockPos, this.getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)world, blockPos, this.getFluid().defaultFluidState()), 3);
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, Player player, TransactionContext transaction) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        int drained = 0;
        while (it.hasNext() && amount > 0) {
            int thisDrained;
            ItemLocation current = it.nextIndexed();
            ResourceHandler containerItem = (ResourceHandler)new ItemAccessItemLocation(player, current).getCapability(Capabilities.Fluid.ITEM);
            if (current.getItemStack(player) == itemStack || containerItem == null || (thisDrained = containerItem.extract((Resource)FluidResource.of((Fluid)fluid), amount, transaction)) <= 0) continue;
            drained += thisDrained;
            amount -= thisDrained;
        }
        return new FluidStack(fluid, drained);
    }

    public boolean canConsume(int amount, ItemStack itemStack, @Nullable Player player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = FluidUtil.getFirstStackContained((ItemStack)itemStack).getAmount();
        try (Transaction tx = Transaction.openRoot();){
            boolean bl = player != null && !this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, (TransactionContext)tx).isEmpty();
            return bl;
        }
    }

    public FluidStack consume(int amount, ItemStack itemStack, @Nullable Player player) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction tx = Transaction.openRoot();){
            FluidStack otherDrained;
            ResourceHandler fluidHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
            FluidResource resource = (FluidResource)fluidHandler.getResource(0);
            int drained = fluidHandler.extract((Resource)resource, amount, (TransactionContext)tx);
            if (drained == amount) {
                FluidStack fluidStack = resource.toStack(drained);
                return fluidStack;
            }
            int toDrain = amount - drained;
            FluidStack fluidStack = otherDrained = player == null ? FluidStack.EMPTY : this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, (TransactionContext)tx);
            if (otherDrained.isEmpty()) {
                FluidStack fluidStack2 = resource.toStack(drained);
                return fluidStack2;
            }
            otherDrained.setAmount(otherDrained.getAmount() + drained);
            if (player == null || !player.isCreative() && !player.level().isClientSide()) {
                tx.commit();
            }
            FluidStack fluidStack3 = otherDrained;
            return fluidStack3;
        }
    }
}

