/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class RecipeBroomPartCombination
extends CustomRecipe {
    public RecipeBroomPartCombination(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput grid, Level world) {
        return !this.assemble(grid, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public ItemStack getResultItem() {
        return new ItemStack(RegistryEntries.ITEM_BROOM);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList aitemstack = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            aitemstack.set(i, (Object)itemstack.getCraftingRemainder());
        }
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inventory);
        if (result != null) {
            List extraOutputs = (List)result.getRight();
            for (ItemStack extraOutput : extraOutputs) {
                IModHelpers.get().getInventoryHelpers().tryReAddToStack(CommonHooks.getCraftingPlayer(), ItemStack.EMPTY, extraOutput, CommonHooks.getCraftingPlayer().getUsedItemHand());
            }
        }
        return aitemstack;
    }

    protected Map<IBroomPart.BroomPartType, IBroomPart> indexifyParts(Collection<IBroomPart> parts) {
        HashMap map = Maps.newHashMap();
        for (IBroomPart part : parts) {
            if (part.getType() == IBroomPart.BroomPartType.MODIFIER) continue;
            map.put(part.getType(), part);
        }
        return map;
    }

    protected Pair<ItemStack, List<ItemStack>> getResult(CraftingInput grid) {
        ItemStack element;
        int j;
        ItemStack output = this.getResultItem().copy();
        LinkedList extraOutputs = Lists.newLinkedList();
        int existingBroomSlot = -1;
        Map<IBroomPart.BroomPartType, IBroomPart> existingBroomParts = null;
        HashMap parts = Maps.newHashMap();
        LinkedList rawModifiers = Lists.newLinkedList();
        for (j = 0; j < grid.size(); ++j) {
            Map<IBroomPart.BroomPartType, IBroomPart> currentExistingBroomParts;
            element = grid.getItem(j);
            if (element.isEmpty() || !(element.getItem() instanceof IBroom) || (currentExistingBroomParts = this.indexifyParts(BroomParts.REGISTRY.getBroomParts(element))) == null || !this.areValidBroomParts(currentExistingBroomParts.values()) || element.getCount() != 1) continue;
            if (existingBroomParts == null) {
                existingBroomParts = currentExistingBroomParts;
                output = element.copy();
                existingBroomSlot = j;
                continue;
            }
            return null;
        }
        for (j = 0; j < grid.size(); ++j) {
            element = grid.getItem(j);
            if (element.isEmpty()) continue;
            Object part = BroomParts.REGISTRY.getPartFromItem(element);
            Map<BroomModifier, Float> modifier = BroomModifiers.REGISTRY.getModifiersFromItem(element);
            if (part != null) {
                if (parts.containsKey(part.getType())) {
                    return null;
                }
                parts.put(part.getType(), part);
                continue;
            }
            if (modifier != null) {
                rawModifiers.add(modifier);
                continue;
            }
            if (j == existingBroomSlot) continue;
            return null;
        }
        if (existingBroomParts != null) {
            for (Map.Entry entry : existingBroomParts.entrySet()) {
                if (parts.containsKey(entry.getKey())) {
                    extraOutputs.add(((ItemStack)Iterables.get(BroomParts.REGISTRY.getItemsFromPart((IBroomPart)entry.getValue()), (int)0)).copy());
                    continue;
                }
                parts.put((IBroomPart.BroomPartType)entry.getKey(), (IBroomPart)entry.getValue());
            }
        }
        if (!this.areValidBroomParts(parts.values())) {
            return null;
        }
        BroomParts.REGISTRY.setBroomParts(output, parts.values());
        Map<BroomModifier, Float> broomModifiers = BroomModifiers.REGISTRY.getModifiers(output);
        Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(output);
        this.applyNewModifiers(broomModifiers, rawModifiers);
        if (!this.areValidBroomModifiers(broomModifiers, baseModifiers)) {
            return null;
        }
        BroomModifiers.REGISTRY.setModifiers(output, broomModifiers);
        return Pair.of((Object)output, (Object)extraOutputs);
    }

    private void applyNewModifiers(Map<BroomModifier, Float> baseModifiers, List<Map<BroomModifier, Float>> rawModifiers) {
        for (Map<BroomModifier, Float> modifierValue : rawModifiers) {
            for (Map.Entry<BroomModifier, Float> entry : modifierValue.entrySet()) {
                BroomModifier modifier = entry.getKey();
                Float value = baseModifiers.get(entry.getKey());
                if (value != null) {
                    baseModifiers.put(modifier, Float.valueOf(modifier.apply(value.floatValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
                    continue;
                }
                baseModifiers.put(modifier, Float.valueOf(modifier.apply(modifier.getDefaultValue(), Lists.newArrayList((Object[])new Float[]{entry.getValue()}))));
            }
        }
    }

    public ItemStack assemble(CraftingInput grid, HolderLookup.Provider registryAccess) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(grid);
        if (result == null) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)result.getLeft();
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_BROOM_PART_COMBINATION.get();
    }

    private boolean areValidBroomParts(Collection<IBroomPart> parts) {
        HashSet remainingRequiredTypes = Sets.newHashSet((Object[])IBroomPart.BroomPartType.BASE_TYPES);
        for (IBroomPart part : parts) {
            remainingRequiredTypes.remove(part.getType());
        }
        return remainingRequiredTypes.isEmpty();
    }

    private boolean areValidBroomModifiers(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = (int)Math.ceil(entry.getValue().floatValue() / entry.getKey().getTierValue());
            if (tier > entry.getKey().getMaxTiers()) {
                return false;
            }
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        broomModifiers.put(BroomModifiers.MODIFIER_COUNT, Float.valueOf((float)maxModifiers - (float)baseMaxModifiers));
        return modifiers <= maxModifiers;
    }
}

