/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;

public class RecipeFluidContainerCombination
extends CustomRecipe {
    private final Ingredient fluidContainer;
    private final int maxCapacity;

    public RecipeFluidContainerCombination(CraftingBookCategory category, Ingredient fluidContainer, int maxCapacity) {
        super(category);
        this.fluidContainer = fluidContainer;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getFluidContainer() {
        return this.fluidContainer;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingInput grid, Level world) {
        return !this.assemble(grid, (HolderLookup.Provider)world.registryAccess()).isEmpty();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList aitemstack = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            aitemstack.set(i, (Object)itemstack.getCraftingRemainder());
        }
        return aitemstack;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_FLUIDCONTAINER_COMBINATION.get();
    }

    public ItemStack assemble(CraftingInput grid, HolderLookup.Provider registryAccess) {
        ItemStack output = new ItemStack((Holder)this.fluidContainer.items().findFirst().get());
        ItemAccess outputItemAccess = ItemAccess.forStack((ItemStack)output);
        IFluidHandlerCapacity fluidHandlerOutput = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(outputItemAccess).orElse(null);
        FluidStack commonFluid = null;
        int totalCapacity = 0;
        int totalContent = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.size(); ++j) {
            ItemStack element = grid.getItem(j).copy().split(1);
            if (element.isEmpty()) continue;
            if (this.fluidContainer.test(element)) {
                IFluidHandlerCapacity fluidHandler = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(ItemAccess.forStack((ItemStack)element)).orElse(null);
                ++inputItems;
                FluidStack fluidStack = IModHelpersNeoForge.get().getFluidHelpers().getFluid((ResourceHandler)fluidHandler);
                if (!fluidStack.isEmpty()) {
                    if (commonFluid == null) {
                        commonFluid = fluidStack;
                    } else if (!FluidStack.isSameFluidSameComponents((FluidStack)commonFluid, (FluidStack)fluidStack)) {
                        return ItemStack.EMPTY;
                    }
                    totalContent = IModHelpers.get().getBaseHelpers().addSafe(totalContent, fluidStack.getAmount() * element.getCount());
                }
                totalCapacity = IModHelpers.get().getBaseHelpers().addSafe(totalCapacity, fluidHandler.getTankCapacity(0) * element.getCount());
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.EMPTY;
        }
        fluidHandlerOutput.setTankCapacity(0, totalCapacity);
        if (commonFluid != null) {
            try (Transaction tx = Transaction.openRoot();){
                fluidHandlerOutput.insert((Resource)FluidResource.of((Holder)commonFluid.getFluidHolder()), totalContent, (TransactionContext)tx);
                tx.commit();
            }
        }
        output = outputItemAccess.getResource().toStack(outputItemAccess.getAmount());
        return output;
    }
}

