/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.enchantment.component;

import java.util.Random;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.cyclops.cyclopscore.helper.EnchantmentHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.algorithm.Wrapper;

public class EnchantmentEffectComponentAmplifyDamage {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void livingDamage(LivingDamageEvent.Post event) {
        ItemStack itemStack;
        LivingEntity entity;
        InteractionHand hand;
        if (!event.getEntity().level().isClientSide() && event.getSource().getEntity() instanceof LivingEntity && (hand = (entity = (LivingEntity)event.getSource().getEntity()).getUsedItemHand()) != null && this.amplifyDamage(itemStack = entity.getItemInHand(hand))) {
            entity.setItemInHand(hand, itemStack);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void breakingEvent(BlockEvent.BreakEvent event) {
        ItemStack itemStack;
        InteractionHand hand;
        if (!event.getPlayer().level().isClientSide() && (hand = event.getPlayer().getUsedItemHand()) != null && this.amplifyDamage(itemStack = event.getPlayer().getItemInHand(hand))) {
            event.getPlayer().setItemInHand(hand, itemStack);
        }
    }

    public boolean amplifyDamage(ItemStack itemStack) {
        Wrapper<Boolean> applied = new Wrapper<Boolean>(false);
        EnchantmentHelpers.runIterationOnItem((ItemStack)itemStack, (enchantment, level) -> {
            int modifier = (Integer)((Enchantment)enchantment.value()).effects().getOrDefault((DataComponentType)RegistryEntries.ENCHANTMENTEFFECT_COMPONENT_AMPLIFY_DAMAGE.get(), (Object)0);
            if (modifier > 0) {
                int newDamage = itemStack.getDamageValue() + modifier;
                Random random = new Random();
                if (!(random.nextFloat() < 0.6f) && random.nextInt(level + 1) > 0 && newDamage <= itemStack.getMaxDamage()) {
                    itemStack.setDamageValue(newDamage);
                    applied.set(true);
                }
            }
        });
        return applied.get();
    }
}

