/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.client.particle.ParticleColoredSmokeData;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class EntityBroom
extends Entity {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.defineId(EntityBroom.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final double SPEED = 0.4;
    public static final float MAX_ANGLE = 60.0f;
    public static final float MIN_ANGLE = -60.0f;
    private static final float MAX_COS_AMPLITUDE = 0.2f;
    public LivingEntity lastMounted = null;
    private boolean setLast = false;
    private double lastPlayerSpeed = 0.0;
    private float lastRotationPitch = -1.0f;
    private float lastRotationYaw = -1.0f;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    private int broomHoverTickOffset;
    private double oldHoverOffset;
    private Map<BroomModifier, Float> cachedModifiers = null;

    public EntityBroom(EntityType<? extends EntityBroom> type, Level world) {
        this(type, world, 0.0, 0.0, 0.0);
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(EntityType<? extends EntityBroom> type, Level world, double x, double y, double z) {
        super(type, world);
        this.setPos(x, y, z);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.refreshDimensions();
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(Level world, double x, double y, double z) {
        this((EntityType<? extends EntityBroom>)((EntityType)RegistryEntries.ENTITY_BROOM.get()), world, x, y, z);
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return EntityDimensions.scalable((float)1.5f, (float)0.6f);
    }

    protected void initBroomHoverTickOffset() {
        this.broomHoverTickOffset = this.random.nextInt(3);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_294756_, EntityDimensions p_295396_, float p_296362_) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!(this.level().isClientSide() || this.isVehicle() || player.isCrouching())) {
            player.startRiding((Entity)this);
            this.lastMounted = player;
        }
        return InteractionResult.SUCCESS;
    }

    public void push(Entity entityIn) {
        Entity controlling;
        if (!(this.level().isClientSide() || entityIn.noPhysics || this.noPhysics || entityIn == (controlling = this.getControllingPassengerRaw()) || !(entityIn instanceof LivingEntity) || entityIn instanceof Player || controlling != null || entityIn.isPassenger())) {
            entityIn.startRiding((Entity)this);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity = this.getControllingPassengerRaw();
        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
    }

    public Entity getControllingPassengerRaw() {
        List list = this.getPassengers();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (this.isAlive() && source.getEntity() instanceof Player && source.getEntity() != this.lastMounted) {
            if (this.isVehicle()) {
                this.stopRiding();
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
                Player player = (Player)source.getEntity();
                if (!player.isCreative()) {
                    ItemStack itemStack = this.getBroomStack().copy();
                    this.spawnAtLocation(level, itemStack, 0.0f);
                }
            }
        }
        return true;
    }

    public void startAllowFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            ((Player)entity).getAbilities().mayfly = true;
        }
    }

    public void stopAllowFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            ((Player)entity).getAbilities().mayfly = false;
        }
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (!this.level().isClientSide() && passenger instanceof LivingEntity) {
            this.startAllowFlying((LivingEntity)passenger);
        }
    }

    public void tick() {
        super.tick();
        Entity rider = this.getControllingPassengerRaw();
        if (!this.level().isClientSide() && !this.isVehicle() && this.lastMounted != null) {
            this.onDismount();
        } else if (rider instanceof LivingEntity) {
            List list;
            this.lastMounted = (LivingEntity)rider;
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            this.xRotO = this.getXRot();
            this.yRotO = this.getYRot();
            if (!this.level().isClientSide() || Minecraft.getInstance().player == this.lastMounted) {
                this.updateMountedServer();
            } else {
                this.updateMountedClient();
            }
            if (IModHelpers.get().getMinecraftHelpers().isClientSide() && this.getModifier(BroomModifiers.PARTICLES) > 0.0f) {
                this.showParticles(this);
            }
            if ((list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    if (entity == rider || !entity.isPushable() || entity instanceof EntityBroom) continue;
                    for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                        for (BroomModifier.ICollisionListener listener : entry.getKey().getCollisionListeners()) {
                            listener.onCollide(this, entity, entry.getValue().floatValue());
                        }
                    }
                    entity.push((Entity)this);
                    float toughnessModifier = 0.5f + this.getModifier(BroomModifiers.STURDYNESS) / BroomModifiers.STURDYNESS.getMaxTierValue() / 2.0f;
                    this.setLastPlayerSpeed(this.getLastPlayerSpeed() * (double)toughnessModifier);
                }
            }
            for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                for (BroomModifier.ITickListener listener : entry.getKey().getTickListeners()) {
                    listener.onTick(this, entry.getValue().floatValue());
                }
            }
        } else {
            if (!this.level().isClientSide() && rider == null) {
                this.collideWithNearbyEntities();
            }
            this.updateUnmounted();
        }
    }

    private void onDismount() {
        if (this.lastMounted instanceof Player) {
            this.stopAllowFlying(this.lastMounted);
            Player player = (Player)this.lastMounted;
            if (player.isAlive() && (!IModHelpers.get().getMinecraftHelpers().isPlayerInventoryFull(player) || player.isCreative())) {
                if (!player.isCreative()) {
                    player.getInventory().add(this.getBroomStack());
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        this.lastMounted = null;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return (float)this.getPassengers().size() < 1.0f + this.getModifier(BroomModifiers.STICKY) / BroomModifiers.STICKY.getMaxTierValue() * 3.0f;
    }

    protected void removePassenger(Entity passenger) {
        if (!this.level().isClientSide() && this.getControllingPassengerRaw() == passenger) {
            this.onDismount();
        }
        super.removePassenger(passenger);
    }

    public void showParticles(EntityBroom broom) {
        Level world = broom.level();
        if (world.isClientSide() && broom.lastMounted.zza != 0.0f) {
            int particles = (int)(broom.getModifier(BroomModifiers.PARTICLES) * (float)broom.getLastPlayerSpeed());
            Triple<Float, Float, Float> color = BroomModifier.getAverageColor(broom.getModifiers());
            for (int i = 0; i < particles; ++i) {
                float r = ((Float)color.getLeft()).floatValue();
                float g = ((Float)color.getMiddle()).floatValue();
                float b = ((Float)color.getRight()).floatValue();
                Vec3 motion = broom.getDeltaMovement();
                world.addParticle((ParticleOptions)new ParticleColoredSmokeData(r, g, b), broom.getX() - motion.x * 1.5 + Math.random() * 0.4 - 0.2, broom.getY() - motion.y * 1.5 + Math.random() * 0.4 - 0.2, broom.getZ() - motion.z * 1.5 + Math.random() * 0.4 - 0.2, motion.x / 10.0, motion.y / 10.0, motion.z / 10.0);
            }
        }
    }

    protected void collideWithNearbyEntities() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, 0.0, (double)0.2f), EntitySelector.NO_SPECTATORS.and(Entity::isPushable));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                this.push(entity);
            }
        }
    }

    protected void updateMountedClient() {
        if (this.newPosRotationIncrements > 0) {
            double x = this.getX() + (this.newPosX - this.getX()) / (double)this.newPosRotationIncrements;
            double y = this.getY() + (this.newPosY - this.getY()) / (double)this.newPosRotationIncrements;
            double z = this.getZ() + (this.newPosZ - this.getZ()) / (double)this.newPosRotationIncrements;
            float yaw = MathHelpers.normalizeAngle_180((float)(this.newRotationYaw - (double)this.getYRot()));
            this.setYRot(this.getYRot() + yaw / (float)this.newPosRotationIncrements);
            this.setXRot((float)((double)this.getXRot() + (this.newRotationPitch - (double)this.getXRot()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.setPos(x, y, z);
            this.setRot(this.getYRot(), this.getXRot());
        }
        this.move(MoverType.SELF, new Vec3(0.0, this.getHoverOffset(), 0.0));
    }

    public boolean canConsume(int amount, LivingEntity entityLiving) {
        ItemStack broomStack = this.getBroomStack();
        return broomStack != null && broomStack.getItem() instanceof IBroom && ((IBroom)broomStack.getItem()).canConsumeBroomEnergy(amount, broomStack, entityLiving);
    }

    public void consume(int amount, LivingEntity entityLiving) {
        float efficiencyFactor = Math.min(0.9f, Math.max(0.0f, this.getModifier(BroomModifiers.EFFICIENCY) / BroomModifiers.EFFICIENCY.getMaxTierValue()));
        if (this.level().random.nextFloat() > efficiencyFactor) {
            ItemStack broomStack = this.getBroomStack();
            ((IBroom)broomStack.getItem()).consumeBroom(amount, broomStack, entityLiving);
            this.setBroomStack(broomStack);
        }
    }

    protected void updateMountedServer() {
        if (!this.setLast) {
            this.setLast = true;
            this.lastRotationYaw = this.getYRot();
            this.lastRotationPitch = this.getXRot();
        }
        if (this.lastMounted instanceof Player) {
            if (this.lastMounted instanceof ServerPlayer) {
                ((ServerPlayer)this.lastMounted).connection.aboveGroundVehicleTickCount = 0;
            }
        } else {
            this.lastMounted.setYRot(this.lastMounted.yHeadRot);
            this.lastMounted.zza = 0.5f;
        }
        this.setXRot(MathHelpers.normalizeAngle_180(this.lastMounted.getXRot()));
        this.setYRot(MathHelpers.normalizeAngle_180(this.lastMounted.getYRot()));
        float maneuverabilityFactor = 1.0f - this.getModifier(BroomModifiers.MANEUVERABILITY) / 2000.0f;
        this.setXRot(this.getXRot() * (1.0f - maneuverabilityFactor) + this.lastRotationPitch * maneuverabilityFactor);
        if (this.lastRotationYaw - this.getYRot() > 180.0f) {
            this.lastRotationYaw -= 360.0f;
        }
        if (this.lastRotationYaw - this.getYRot() < -180.0f) {
            this.lastRotationYaw += 360.0f;
        }
        this.setYRot(this.getYRot() * (1.0f - maneuverabilityFactor) + this.lastRotationYaw * maneuverabilityFactor);
        this.lastRotationPitch = this.getXRot();
        this.lastRotationYaw = this.getYRot();
        if (this.getXRot() > 60.0f) {
            this.setXRot(60.0f);
        } else if (this.getXRot() < -60.0f) {
            this.setXRot(-60.0f);
        }
        this.setRot(this.getYRot(), this.getXRot());
        double pitch = (double)(this.getXRot() + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(this.getYRot() + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        double playerSpeed = this.lastMounted.getAttribute(Attributes.MOVEMENT_SPEED).getValue();
        playerSpeed += (double)(this.getModifier(BroomModifiers.SPEED) / 100.0f);
        int amount = ItemBroomConfig.bloodUsage;
        LivingEntity currentRidingEntity = this.getControllingPassenger();
        float moveForward = this.canConsume(amount, currentRidingEntity) ? this.lastMounted.zza : this.lastMounted.zza / 10.0f;
        playerSpeed *= (double)moveForward;
        if (moveForward != 0.0f) {
            this.consume(amount, currentRidingEntity);
        }
        float slowingFactor = 1.0f - (this.getModifier(BroomModifiers.ACCELERATION) + 1.0f) / 2500.0f;
        playerSpeed = playerSpeed * (1.0 - (double)slowingFactor) + this.lastPlayerSpeed * (double)slowingFactor;
        float levitation = this.getModifier(BroomModifiers.LEVITATION);
        float levitationModifier = levitation / BroomModifiers.LEVITATION.getMaxTierValue() * 1.5f;
        levitationModifier = Math.max(0.2f, levitationModifier);
        if (y < 0.0) {
            levitationModifier = Math.max(1.0f, levitationModifier);
        }
        this.lastPlayerSpeed = playerSpeed;
        if (this.wasTouchingWater) {
            float waterMovementFactor = Mth.clamp((float)(this.getModifier(BroomModifiers.SWIMMING) / BroomModifiers.SWIMMING.getMaxTierValue()), (float)0.0f, (float)1.0f);
            waterMovementFactor = (float)Math.log10(1.0f + waterMovementFactor * 9.0f);
            playerSpeed *= (double)waterMovementFactor;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.1, 0.1, 0.1).add(x * 0.4 * playerSpeed, y * 0.4 * playerSpeed * (double)levitationModifier, z * 0.4 * playerSpeed));
        if (this.level().isClientSide()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, this.getHoverOffset(), 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public double getLastPlayerSpeed() {
        return this.lastPlayerSpeed;
    }

    public void setLastPlayerSpeed(double lastPlayerSpeed) {
        this.lastPlayerSpeed = lastPlayerSpeed;
    }

    protected void updateUnmounted() {
        if (this.level().isClientSide()) {
            this.move(MoverType.SELF, new Vec3(0.0, this.getHoverOffset(), 0.0));
        }
    }

    protected double getHoverOffset() {
        float x = this.level().getGameTime();
        float t = this.broomHoverTickOffset;
        double newHoverOffset = Math.cos(x / 10.0f + t) * Math.cos(x / 12.0f + t) * Math.cos(x / 15.0f + t) * (double)0.2f;
        double newHoverDifference = newHoverOffset - this.oldHoverOffset;
        this.oldHoverOffset += newHoverDifference;
        return newHoverDifference;
    }

    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return this.getModifier(BroomModifiers.SWIMMING) > 0.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEMSTACK_INDEX, (Object)new ItemStack(RegistryEntries.ITEM_BROOM));
    }

    protected void readAdditionalSaveData(ValueInput p_422333_) {
    }

    protected void addAdditionalSaveData(ValueOutput p_421996_) {
    }

    public void setBroomStack(ItemStack itemStack) {
        this.entityData.set(ITEMSTACK_INDEX, (Object)itemStack.copy());
    }

    public ItemStack getBroomStack() {
        ItemStack itemStack = (ItemStack)this.entityData.get(ITEMSTACK_INDEX);
        if (itemStack.isEmpty()) {
            itemStack = new ItemStack(RegistryEntries.ITEM_BROOM);
        }
        itemStack.setCount(1);
        return itemStack;
    }

    public Map<BroomModifier, Float> getModifiers() {
        if (this.cachedModifiers == null) {
            this.cachedModifiers = Maps.newHashMap();
            ItemStack broomStack = this.getBroomStack();
            Map<BroomModifier, Float> modifiers = BroomModifiers.REGISTRY.getModifiers(broomStack);
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(broomStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(modifiers.keySet());
            modifierTypes.addAll(baseModifiers.keySet());
            for (BroomModifier modifier : modifierTypes) {
                float value = modifier.getDefaultValue();
                if (baseModifiers.containsKey(modifier)) {
                    value = baseModifiers.get(modifier).floatValue();
                }
                if (modifiers.containsKey(modifier)) {
                    value = modifier.apply(value, Lists.newArrayList((Object[])new Float[]{modifiers.get(modifier)}));
                }
                this.cachedModifiers.put(modifier, Float.valueOf(value));
            }
        }
        return this.cachedModifiers;
    }

    public float getModifier(BroomModifier modifier) {
        Float value = this.getModifiers().get(modifier);
        if (value == null) {
            return modifier.getDefaultValue();
        }
        return value.floatValue();
    }

    public void saveWithoutId(ValueOutput valueOutput) {
        super.saveWithoutId(valueOutput);
        valueOutput.store("broomItem", ItemStack.OPTIONAL_CODEC, (Object)this.getBroomStack());
    }

    public void load(ValueInput valueInput) {
        super.load(valueInput);
        ItemStack broomStack = (ItemStack)valueInput.read("broomItem", ItemStack.OPTIONAL_CODEC).orElseThrow();
        if (!broomStack.isEmpty()) {
            this.setBroomStack(broomStack);
        }
    }
}

