/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.entity.item.EntityThrowable;
import org.cyclops.evilcraft.item.ItemWeatherContainer;

public class EntityWeatherContainer
extends EntityThrowable {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.defineId(EntityWeatherContainer.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public EntityWeatherContainer(EntityType<? extends EntityWeatherContainer> type, Level world) {
        super(type, world);
    }

    public EntityWeatherContainer(Level world, LivingEntity entity) {
        super((EntityType<? extends EntityThrowable>)((EntityType)RegistryEntries.ENTITY_WEATHER_CONTAINER.get()), world, entity);
    }

    public EntityWeatherContainer(Level world, LivingEntity entity, ItemStack stack) {
        this(world, entity);
        this.setItem(stack);
    }

    public static void playImpactSounds(Level world) {
        if (!world.isClientSide()) {
            for (Object o : world.players()) {
                Player entityPlayer = (Player)o;
                world.playSound((Entity)entityPlayer, entityPlayer.getX(), entityPlayer.getY(), entityPlayer.getZ(), SoundEvents.PORTAL_TRAVEL, SoundSource.WEATHER, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
                world.playSound((Entity)entityPlayer, entityPlayer.getX(), entityPlayer.getY(), entityPlayer.getZ(), SoundEvents.GHAST_AMBIENT, SoundSource.WEATHER, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
                world.playSound((Entity)entityPlayer, entityPlayer.getX(), entityPlayer.getY(), entityPlayer.getZ(), SoundEvents.WITHER_DEATH, SoundSource.WEATHER, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            }
        }
    }

    protected void onHit(HitResult movingobjectposition) {
        if (movingobjectposition.getType() == HitResult.Type.BLOCK) {
            ItemStack stack = this.getItem();
            ItemWeatherContainer.WeatherContainerType containerType = ItemWeatherContainer.getWeatherType(stack);
            if (this.level() instanceof ServerLevel) {
                containerType.onUse((ServerLevel)this.level(), stack);
            }
            EntityWeatherContainer.playImpactSounds(this.level());
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.AMBIENT, 0.5f, 0.4f, false);
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)SpellParticleOption.create((ParticleType)ParticleTypes.EFFECT, (int)-1, (float)1.0f), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected double getDefaultGravity() {
        return 0.1;
    }

    private void setItem(ItemStack stack) {
        this.entityData.set(ITEMSTACK_INDEX, (Object)stack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ITEMSTACK_INDEX, (Object)new ItemStack(RegistryEntries.ITEM_WEATHER_CONTAINER));
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEMSTACK_INDEX);
    }
}

