/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockInfestedNether;

public class EntityNetherfish
extends Silverfish {
    private static final int MAX_FIRE_DURATION = 3;
    private static final double FIRE_CHANCE = 0.5;

    public EntityNetherfish(EntityType<? extends EntityNetherfish> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.xpReward = 10;
    }

    public EntityNetherfish(Level world) {
        this((EntityType<? extends EntityNetherfish>)((EntityType)RegistryEntries.ENTITY_NETHERFISH.get()), world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(5, (Goal)new AIHideInStone());
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        if ((double)this.random.nextFloat() < 0.5) {
            entity.setRemainingFireTicks(this.random.nextInt(3));
        }
        return super.doHurtTarget(level, entity);
    }

    public void aiStep() {
        if (this.level().isClientSide() && this.random.nextInt(30) == 0) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    class AIHideInStone
    extends RandomStrollGoal {
        private Direction selectedDirection;
        private boolean doMerge;
        private static final String __OBFID = "CL_00002205";

        public AIHideInStone() {
            super((PathfinderMob)EntityNetherfish.this, 1.0, 10);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (EntityNetherfish.this.getTarget() != null) {
                return false;
            }
            if (!EntityNetherfish.this.getNavigation().isDone()) {
                return false;
            }
            RandomSource random = EntityNetherfish.this.getRandom();
            if (random.nextInt(10) == 0) {
                this.selectedDirection = Direction.getRandom((RandomSource)random);
                BlockPos blockpos = BlockPos.containing((double)EntityNetherfish.this.getX(), (double)(EntityNetherfish.this.getY() + 0.5), (double)EntityNetherfish.this.getZ()).relative(this.selectedDirection);
                BlockInfestedNether.Type type = BlockInfestedNether.unwrapBlock(EntityNetherfish.this.level().getBlockState(blockpos));
                if (type != null) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return this.doMerge ? false : super.canContinueToUse();
        }

        public void start() {
            if (!this.doMerge) {
                super.start();
            } else {
                BlockPos blockpos = BlockPos.containing((double)EntityNetherfish.this.getX(), (double)(EntityNetherfish.this.getY() + 0.5), (double)EntityNetherfish.this.getZ()).relative(this.selectedDirection);
                BlockInfestedNether.Type type = BlockInfestedNether.unwrapBlock(EntityNetherfish.this.level().getBlockState(blockpos));
                if (type != null) {
                    EntityNetherfish.this.level().setBlockAndUpdate(blockpos, BlockInfestedNether.wrapBlock(type).defaultBlockState());
                    EntityNetherfish.this.spawnAnim();
                    EntityNetherfish.this.remove(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }
}

