/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockGemStoneTorchConfig;
import org.cyclops.evilcraft.client.particle.ParticleDarkSmokeData;
import org.cyclops.evilcraft.core.monster.EntityNoMob;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritConfig;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritSyncedData;
import org.cyclops.evilcraft.item.ItemBurningGemStone;
import org.cyclops.evilcraft.item.ItemSpectralGlasses;
import org.cyclops.evilcraft.item.ItemVengeanceRing;

public class EntityVengeanceSpirit
extends EntityNoMob {
    private static final Set<String> IMC_BLACKLIST = Sets.newHashSet();
    public static final int REMAININGLIFE_MIN = 250;
    public static final int REMAININGLIFE_MAX = 1000;
    public static final EntityDataAccessor<String> WATCHERID_INNER = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> WATCHERID_REMAININGLIFE = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WATCHERID_FROZENDURATION = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WATCHERID_GLOBALVENGEANCE = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> WATCHERID_VENGEANCEPLAYERS = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> WATCHERID_ISSWARM = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WATCHERID_SWARMTIER = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WATCHERID_BUILDUP = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> WATCHERID_PLAYERID = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> WATCHERID_PLAYERNAME = SynchedEntityData.defineId(EntityVengeanceSpirit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final TagKey<Block> TAG_SPIRIT_BLOCKER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)"evilcraft:vengeance_spirit_blocker"));
    private EntityVengeanceSpiritSyncedData data;
    private Mob innerEntity = null;
    @Nullable
    private EntityType<?> preferredInnerEntity;
    private final Set<ServerPlayer> entanglingPlayers = Sets.newHashSet();

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, Level level) {
        this(type, level, null);
    }

    public EntityVengeanceSpirit(Level level) {
        this((EntityType<? extends EntityVengeanceSpirit>)((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()), level, null);
    }

    public EntityVengeanceSpirit(EntityType<? extends EntityVengeanceSpirit> type, Level level, @Nullable EntityType<?> preferredInnerEntity) {
        super(type, level);
        this.preferredInnerEntity = preferredInnerEntity;
        this.blocksBuilding = false;
        float damage = 0.5f;
        int remainingLife = Mth.nextInt((RandomSource)this.getRandom(), (int)250, (int)1000);
        if (this.isSwarm()) {
            damage = (float)((double)damage + 0.5 * (double)this.getSwarmTier());
            remainingLife += 750 * this.getSwarmTier();
        }
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, damage));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.setRemainingLife(remainingLife);
        this.setFrozenDuration(0);
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        if (attribute == Attributes.MOVEMENT_SPEED) {
            double speed = 0.25;
            if (this.isSwarm()) {
                speed += 0.125 * (double)this.getSwarmTier();
            }
            return speed;
        }
        return super.getAttributeValue(attribute);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void vengeanceEvent(LivingDeathEvent event) {
        if (event.getEntity() != null) {
            Level level = event.getEntity().level();
            boolean directToPlayer = EntityVengeanceSpirit.shouldDirectSpiritToPlayer(event);
            if (!level.isClientSide() && level.getDifficulty() != Difficulty.PEACEFUL && (EntityVengeanceSpiritConfig.spawnOnNonPlayerKills || event.getSource().getEntity() instanceof Player) && EntityVengeanceSpirit.canSustain(event.getEntity()) && (directToPlayer || EntityVengeanceSpirit.canSpawnNew(level, event.getEntity().blockPosition()))) {
                EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
                spirit.setInnerEntity(event.getEntity());
                spirit.copyPosition((Entity)event.getEntity());
                level.addFreshEntity((Entity)spirit);
                if (directToPlayer) {
                    Player player = (Player)event.getSource().getDirectEntity();
                    spirit.setBuildupDuration(3 * IModHelpers.get().getMinecraftHelpers().getSecondInTicks());
                    spirit.setGlobalVengeance(true);
                    spirit.setTarget((LivingEntity)player);
                }
            }
        }
    }

    private static boolean shouldDirectSpiritToPlayer(LivingDeathEvent event) {
        if (event.getSource().getDirectEntity() instanceof Player) {
            Player player = (Player)event.getSource().getDirectEntity();
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            while (it.hasNext()) {
                ItemStack itemStack = it.next();
                if (itemStack.isEmpty() || !(itemStack.getItem() instanceof ItemVengeanceRing)) continue;
                return true;
            }
        }
        return false;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.data = this.preferredInnerEntity == null ? new EntityVengeanceSpiritSyncedData(builder, () -> ((EntityVengeanceSpirit)this).getEntityData(), EntityVengeanceSpiritData.getRandomInnerEntity(this.random)) : new EntityVengeanceSpiritSyncedData(builder, () -> ((EntityVengeanceSpirit)this).getEntityData(), this.preferredInnerEntity);
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        this.data.writeNBT(valueOutput);
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.data.readNBT(valueInput);
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        return Optional.of(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)("entities/" + BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()).getPath()))));
    }

    public float getVoicePitch() {
        return super.getVoicePitch() / 3.0f;
    }

    public boolean isInvulnerableTo(ServerLevel level, DamageSource damageSource) {
        return !damageSource.is(ExtendedDamageSources.DAMAGE_TYPE_VENGEANCE_BEAM) && damageSource != level.damageSources().fellOutOfWorld() && damageSource != level.damageSources().genericKill();
    }

    public boolean doHurtTarget(ServerLevel level, Entity entity) {
        Player player;
        if (this.getBuildupDuration() > 0) {
            return false;
        }
        this.remove(Entity.RemovalReason.KILLED);
        if (entity instanceof Player && ItemBurningGemStone.damageForPlayer(player = (Player)entity, this.isSwarm() ? this.getSwarmTier() : 0, false)) {
            entity.setDeltaMovement((double)(-Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)) * 0.01f), 0.025, (double)(Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * 0.01f));
            entity.hurt(this.level().damageSources().mobAttack((LivingEntity)this), 0.1f);
            return false;
        }
        return super.doHurtTarget(level, entity);
    }

    protected void dropFromLootTable(ServerLevel level, DamageSource damageSource, boolean fromPlayer) {
        ResourceKey deathLootTable;
        super.dropFromLootTable(level, damageSource, fromPlayer);
        Mob innerEntity = this.getInnerEntity();
        if (innerEntity != null && damageSource != this.level().damageSources().fellOutOfWorld() && (deathLootTable = (ResourceKey)innerEntity.getLootTable().orElse(null)) != null) {
            LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(deathLootTable);
            LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)innerEntity).withParameter(LootContextParams.ORIGIN, (Object)new Vec3(this.getX(), this.getY(), this.getZ())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.level().damageSources().generic()).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, null).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, null);
            Player lastHurtByPlayer = this.getLastHurtByPlayer();
            if (fromPlayer && lastHurtByPlayer != null) {
                lootcontext$builder = lootcontext$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)lastHurtByPlayer).withLuck(lastHurtByPlayer.getLuck());
            }
            for (ItemStack itemstack : loottable.getRandomItems(lootcontext$builder.create(LootContextParamSets.ENTITY))) {
                this.spawnAtLocation(level, itemstack, 0.0f);
            }
        }
    }

    public void remove(Entity.RemovalReason removalReason) {
        super.remove(removalReason);
        if (this.level().isClientSide() && this.isVisible()) {
            this.spawnSmoke();
            this.playSound(this.getDeathSound(), 0.1f + this.level().random.nextFloat() * 0.9f, 0.1f + this.level().random.nextFloat() * 0.9f);
        }
    }

    public boolean isImmobile() {
        return this.isFrozen() || this.getBuildupDuration() > 0;
    }

    @Override
    public void aiStep() {
        int buildupDuration;
        super.aiStep();
        if (this.isVisible()) {
            if (this.innerEntity != null) {
                this.innerEntity.deathTime = this.deathTime;
                this.innerEntity.setTarget(this.getTarget());
                this.innerEntity.hurtTime = this.hurtTime;
                this.innerEntity.setXRot(this.getXRot());
                this.innerEntity.setYRot(this.getYRot());
                this.innerEntity.xRotO = this.xRotO;
                this.innerEntity.yRotO = this.yRotO;
                this.innerEntity.yBodyRot = this.yBodyRot;
                this.innerEntity.yBodyRotO = this.yBodyRotO;
                this.innerEntity.yHeadRot = this.yHeadRot;
                this.innerEntity.yHeadRotO = this.yHeadRotO;
            }
            if (this.level().isClientSide()) {
                this.spawnSmoke();
                if (this.isSwarm()) {
                    this.spawnSwarmParticles();
                }
            }
        }
        if ((buildupDuration = this.getBuildupDuration()) > 0) {
            this.setBuildupDuration(buildupDuration - 1);
        }
        if (this.isFrozen()) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.addFrozenDuration(-1);
        } else {
            this.setRemainingLife(this.getRemainingLife() - 1);
            if (this.getRemainingLife() <= 0) {
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    private void spawnSmoke() {
        EntityDimensions size = this.getDimensions(this.getPose());
        int numParticles = this.random.nextInt(5);
        if (!this.isAlive()) {
            numParticles *= 10;
        }
        float clearRange = size.width();
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.getX() - (double)(size.width() / 2.0f) + (double)(size.width() * this.random.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.width() / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.width() / 2.0f);
            }
            double particleY = this.getY() + (double)(size.height() * this.random.nextFloat());
            double particleZ = this.getZ() - (double)(size.width() / 2.0f) + (double)(size.width() * this.random.nextFloat());
            if (particleZ < (double)clearRange && particleZ >= 0.0) {
                particleZ += (double)(size.width() / 2.0f);
            }
            if (particleZ > (double)(-clearRange) && particleZ <= 0.0) {
                particleZ -= (double)(size.width() / 2.0f);
            }
            float particleMotionX = (-0.5f + this.random.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.random.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.random.nextFloat()) * 0.05f;
            this.level().addParticle((ParticleOptions)new ParticleDarkSmokeData(!this.isAlive()), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    private void spawnSwarmParticles() {
        EntityDimensions size = this.getDimensions(this.getPose());
        int numParticles = 5 * (this.random.nextInt((this.getSwarmTier() << 1) + 1) + 1);
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.getX() - (double)(size.width() / 2.0f) + (double)(size.width() * this.random.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(size.width() / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(size.width() / 2.0f);
            }
            double particleY = this.getY() + (double)(size.height() * this.random.nextFloat());
            double particleZ = this.getZ() - (double)(size.width() / 2.0f) + (double)(size.width() * this.random.nextFloat());
            float particleMotionX = (-0.5f + this.random.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.random.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.random.nextFloat()) * 0.05f;
            this.level().addParticle((ParticleOptions)RegistryEntries.PARTICLE_DEGRADE.get(), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn != null && this.isVisible() && !this.isSilent()) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), soundIn, this.getSoundSource(), volume, pitch, true);
        }
    }

    public boolean isVisible() {
        return this.level().isClientSide() && (this.isAlternativelyVisible() || this.isClientVisible());
    }

    private boolean isClientVisible() {
        Player player = IModHelpers.get().getMinecraftClientHelpers().getPlayer();
        if (this.isEnabledVengeance(player)) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof ItemSpectralGlasses)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlternativelyVisible() {
        Player player = IModHelpers.get().getMinecraftClientHelpers().getPlayer();
        return EntityVengeanceSpiritConfig.alwaysVisibleInCreative && player != null && player.isCreative();
    }

    protected void pushEntities() {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public void thunderHit(ServerLevel level, LightningBolt lightning) {
        this.setGlobalVengeance(true);
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity instanceof Player) {
            return this.isEnabledVengeance((Player)entity);
        }
        return super.hasLineOfSight(entity);
    }

    public boolean isEnabledVengeance(Player player) {
        return this.isGlobalVengeance() || player != null && ArrayUtils.contains((Object[])this.getVengeancePlayers(), (Object)player.getName());
    }

    public void setEnabledVengeance(Player player, boolean enabled) {
        Object[] players = this.getVengeancePlayers();
        int index = ArrayUtils.indexOf((Object[])players, (Object)player.getDisplayName().getString());
        if (enabled && index == -1) {
            players = (String[])ArrayUtils.add((Object[])players, (Object)player.getName().getString());
        } else if (!enabled && index != -1) {
            players = (String[])ArrayUtils.remove((Object[])players, (int)index);
        }
        this.setVengeancePlayers((String[])players);
    }

    public boolean isPlayer() {
        return this.containsPlayer();
    }

    protected EntityDimensions getDefaultDimensions(Pose poseIn) {
        if (this.isSwarm()) {
            return EntityDimensions.scalable((float)(this.getSwarmTier() / 3 + 1), (float)(this.getSwarmTier() / 2 + 1));
        }
        Mob innerEntity = this.getInnerEntity();
        if (innerEntity != null) {
            return innerEntity.getDimensions(poseIn);
        }
        return super.getDefaultDimensions(poseIn);
    }

    @Nullable
    public Mob getInnerEntity() {
        if (this.isSwarm()) {
            return null;
        }
        EntityType<?> entityType = this.data.getInnerEntityType();
        if (this.innerEntity != null && entityType != null && entityType == this.innerEntity.getType()) {
            return this.innerEntity;
        }
        try {
            Entity entity;
            if (entityType != RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get() && EntityVengeanceSpirit.canSustain((LivingEntity)(entity = entityType.create(this.level(), EntitySpawnReason.LOAD)))) {
                this.innerEntity = (Mob)entity;
                return this.innerEntity;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void setInnerEntity(LivingEntity innerEntity) {
        if (innerEntity instanceof Player) {
            this.setPlayerId(((Player)innerEntity).getGameProfile().id().toString());
            this.setPlayerName(((Player)innerEntity).getGameProfile().name());
            this.data.setInnerEntityType(EntityType.ZOMBIE);
        } else {
            this.data.setInnerEntityType(innerEntity.getType());
        }
    }

    public static boolean canSustain(LivingEntity entityLiving) {
        String entityName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityLiving.getType()).toString();
        for (String blacklistedRegex : EntityVengeanceSpiritConfig.entityBlacklist) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        for (String blacklistedRegex : IMC_BLACKLIST) {
            if (!entityName.matches(blacklistedRegex)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawnNew(Level level, BlockPos blockPos) {
        int area = EntityVengeanceSpiritConfig.spawnLimitArea;
        int threshold = EntityVengeanceSpiritConfig.spawnLimit;
        AABB box = new AABB((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()).inflate((double)area, (double)area, (double)area);
        List spirits = level.getEntitiesOfClass(EntityVengeanceSpirit.class, box);
        if (spirits.size() >= threshold) {
            return false;
        }
        return (Boolean)IModHelpers.get().getWorldHelpers().foldArea((LevelAccessor)level, BlockGemStoneTorchConfig.area, blockPos, (input, level1, blockPos1) -> input != false && !level1.getBlockState(blockPos1).is(TAG_SPIRIT_BLOCKER), (Object)true);
    }

    public void onHit(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        this.addFrozenDuration(this.level().random.nextInt(4) + 3);
        if (this.level().isClientSide()) {
            this.showBurstParticles(hitX, hitY, hitZ, impactMotionX, impactMotionY, impactMotionZ);
        }
    }

    private void showBurstParticles(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        for (int i = 0; i < this.level().random.nextInt(5); ++i) {
            float scale = 0.04f - this.random.nextFloat() * 0.02f;
            float red = this.random.nextFloat() * 0.2f + 0.3f;
            float green = this.random.nextFloat() * 0.2f + 0.3f;
            float blue = this.random.nextFloat() * 0.01f;
            float ageMultiplier = (float)(this.random.nextDouble() * 0.5 + 3.0);
            double dx = 0.1 - this.random.nextDouble() * 0.2 - impactMotionX * 0.1;
            double dy = 0.1 - this.random.nextDouble() * 0.2 - impactMotionY * 0.1;
            double dz = 0.1 - this.random.nextDouble() * 0.2 - impactMotionZ * 0.1;
            this.level().addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), hitX, hitY, hitZ, dx, dy, dz);
        }
    }

    public static EntityVengeanceSpirit spawnRandom(Level level, BlockPos blockPos, int area) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
        int baseDistance = 5;
        for (int attempts = 50; EntityVengeanceSpirit.canSpawnNew(level, blockPos) && attempts > 0; --attempts) {
            BlockPos spawnPos = blockPos.offset(Mth.nextInt((RandomSource)spirit.random, (int)baseDistance, (int)(baseDistance + area)) * Mth.nextInt((RandomSource)spirit.random, (int)-1, (int)1), Mth.nextInt((RandomSource)spirit.random, (int)0, (int)3) * Mth.nextInt((RandomSource)spirit.random, (int)-1, (int)1), Mth.nextInt((RandomSource)spirit.random, (int)baseDistance, (int)(baseDistance + area)) * Mth.nextInt((RandomSource)spirit.random, (int)-1, (int)1));
            if (!IModHelpers.get().getBlockHelpers().doesBlockHaveSolidTopSurface((LevelReader)level, spawnPos.offset(0, -1, 0))) continue;
            spirit.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.5, (double)spawnPos.getZ() + 0.5);
            if (level.noCollision((Entity)spirit) || level.containsAnyLiquid(spirit.getBoundingBox())) continue;
            level.addFreshEntity((Entity)spirit);
            return spirit;
        }
        return null;
    }

    @Override
    public SoundEvent getDeathSound() {
        if (this.getInnerEntity() != null) {
            try {
                return this.getInnerEntity().getDeathSound();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return (SoundEvent)RegistryEntries.SOUNDEVENT_MOB_VENGEANCESPIRIT_DEATH.get();
    }

    public SoundEvent getAmbientSound() {
        Mob entity = this.getInnerEntity();
        if (entity != null) {
            try {
                return this.getInnerEntity().getAmbientSound();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return (SoundEvent)RegistryEntries.SOUNDEVENT_MOB_VENGEANCESPIRIT_AMBIENT.get();
    }

    public static void addToBlacklistIMC(String entityName) {
        IMC_BLACKLIST.add(entityName);
        EvilCraft.clog("Added entity name " + entityName + " to the spirit blacklist.", org.apache.logging.log4j.Level.TRACE);
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return this.wasTouchingWater;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public static EntityVengeanceSpirit fromNBT(Level level, CompoundTag spiritTag) {
        EntityVengeanceSpirit spirit = new EntityVengeanceSpirit(level);
        IModHelpers.get().getMinecraftHelpers().valueInputFromNbtVoid(spiritTag, (HolderLookup.Provider)level.registryAccess(), spirit::readAdditionalSaveData);
        return spirit;
    }

    public void addEntanglingPlayer(ServerPlayer player) {
        this.entanglingPlayers.add(player);
    }

    public Set<ServerPlayer> getEntanglingPlayers() {
        return this.entanglingPlayers;
    }

    public EntityVengeanceSpiritSyncedData getData() {
        return this.data;
    }

    public void register(SynchedEntityData.Builder builder) {
        this.data.register(builder);
    }

    public EntityType<?> getInnerEntityType() {
        return this.data.getInnerEntityType();
    }

    public void setInnerEntityType(EntityType<?> innerEntityType) {
        this.data.setInnerEntityType(innerEntityType);
    }

    public int getRemainingLife() {
        return this.data.getRemainingLife();
    }

    public void setRemainingLife(int remainingLife) {
        this.data.setRemainingLife(remainingLife);
    }

    public int getFrozenDuration() {
        return this.data.getFrozenDuration();
    }

    public void setFrozenDuration(int frozenDuration) {
        this.data.setFrozenDuration(frozenDuration);
    }

    public String getPlayerId() {
        return this.data.getPlayerId();
    }

    public void setPlayerId(String playerId) {
        this.data.setPlayerId(playerId);
    }

    public String getPlayerName() {
        return this.data.getPlayerName();
    }

    public void setPlayerName(String playerName) {
        this.data.setPlayerName(playerName);
    }

    public boolean isSwarm() {
        return this.data.isSwarm();
    }

    public void setSwarm(boolean isSwarm) {
        this.data.setSwarm(isSwarm);
    }

    public int getSwarmTier() {
        return this.data.getSwarmTier();
    }

    public void setSwarmTier(int swarmTier) {
        this.data.setSwarmTier(swarmTier);
    }

    public boolean isGlobalVengeance() {
        return this.data.isGlobalVengeance();
    }

    public void setGlobalVengeance(boolean globalVengeance) {
        this.data.setGlobalVengeance(globalVengeance);
    }

    public String[] getVengeancePlayers() {
        return this.data.getVengeancePlayers();
    }

    public void setVengeancePlayers(String[] vengeancePlayers) {
        this.data.setVengeancePlayers(vengeancePlayers);
    }

    public boolean isFrozen() {
        return this.data.isFrozen();
    }

    public void addFrozenDuration(int amount) {
        this.data.addFrozenDuration(amount);
    }

    public boolean containsPlayer() {
        return this.data.containsPlayer();
    }

    public boolean hasInnerEntity() {
        return this.data.hasInnerEntity();
    }

    public void setRandomSwarmTier(Random random) {
        this.data.setRandomSwarmTier(random);
    }

    public void readNBT(ValueInput valueInput) {
        this.data.readNBT(valueInput);
    }

    public void writeNBT(ValueOutput valueOutput) {
        this.data.writeNBT(valueOutput);
    }

    public UUID getPlayerUUID() {
        return this.data.getPlayerUUID();
    }

    public int getBuildupDuration() {
        return this.data.getBuildupDuration();
    }

    public void setBuildupDuration(int buildupDuration) {
        this.data.setBuildupDuration(buildupDuration);
    }
}

