/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;

public class GameTestsBloodInfuser {
    public static final String TEMPLATE_EMPTY = "evilcraft:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="evilcraft:empty10")
    public void testBloodInfuserDarkPowerGem(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_DARK_GEM));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above(), BlockEntityDarkTank.class);
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 8000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_DARK_POWER_GEM.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserBowlOfPromisesTier0(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 5000));
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_BOWL_OF_PROMISES_DUSTED));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_BOWL_OF_PROMISES_TIER0.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserBowlOfPromisesTier1(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 5000));
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_BOWL_OF_PROMISES_DUSTED));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_TIER_1, 1));
        infuser.getInventory().setItem(4, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_BOWL_OF_PROMISES_TIER1.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserBowlOfPromisesTier2(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 5000));
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_BOWL_OF_PROMISES_DUSTED));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_TIER_2, 1));
        infuser.getInventory().setItem(4, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_BOWL_OF_PROMISES_TIER2.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserBowlOfPromisesTier3(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 5000));
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_BOWL_OF_PROMISES_DUSTED));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_TIER_3, 1));
        infuser.getInventory().setItem(4, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_BOWL_OF_PROMISES_TIER3.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserDarkTank(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(1, new ItemStack(RegistryEntries.ITEM_DARK_TANK));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above(), BlockEntityDarkTank.class);
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 16000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> {
            helper.assertTrue(infuser.getInventory().getItem(1).isEmpty(), (Component)Component.literal((String)"Infuse slot is not empty"));
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_DARK_TANK.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertValueEqual((Object)16000, (Object)((ResourceHandler)ItemAccess.forStack((ItemStack)infuser.getInventory().getItem(2)).getCapability(Capabilities.Fluid.ITEM)).getAmountAsInt(0), (Component)Component.literal((String)"Container content amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)((FluidResource)((ResourceHandler)ItemAccess.forStack((ItemStack)infuser.getInventory().getItem(2)).getCapability(Capabilities.Fluid.ITEM)).getResource(0)).getFluid(), (Component)Component.literal((String)"Container content fluid"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
            helper.assertValueEqual((Object)0, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testBloodInfuserBucket(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(1, new ItemStack((ItemLike)Items.BUCKET));
        infuser.getInventory().setItem(3, new ItemStack(RegistryEntries.ITEM_PROMISE_SPEED, 4));
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above(), BlockEntityDarkTank.class);
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 1000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> {
            helper.assertTrue(infuser.getInventory().getItem(1).isEmpty(), (Component)Component.literal((String)"Infuse slot is not empty"));
            helper.assertFalse(infuser.getInventory().getItem(2).isEmpty(), (Component)Component.literal((String)"Result is not available"));
            helper.assertTrue(infuser.getInventory().getItem(2).getItem() == RegistryEntries.ITEM_BUCKET_BLOOD.get(), (Component)Component.literal((String)"Result item is wrong"));
            helper.assertTrue(infuser.getInventory().getItem(2).getCount() == 1, (Component)Component.literal((String)"Result item count is wrong"));
            helper.assertValueEqual((Object)0, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserEmptyFluidContainerBucket(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(0, new ItemStack(RegistryEntries.ITEM_BUCKET_BLOOD));
        helper.succeedWhen(() -> {
            helper.assertTrue(infuser.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Container was not drained"));
            helper.assertValueEqual((Object)1000, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserEmptyCondensedBloodDrops(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(0, new ItemStack(RegistryEntries.ITEM_CONDENSED_BLOOD, 10));
        helper.succeedWhen(() -> {
            helper.assertTrue(infuser.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Container was not drained"));
            helper.assertValueEqual((Object)5000, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserEmptyFluidContainerCreativeBloodDrop(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        infuser.getInventory().setItem(0, new ItemStack(RegistryEntries.ITEM_CREATIVE_BLOOD_DROP));
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Container was incorrectly destroyed"));
            helper.assertValueEqual((Object)10000, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testBloodInfuserEmptyFluidContainerTank(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get());
        BlockEntityBloodInfuser infuser = (BlockEntityBloodInfuser)helper.getBlockEntity(POS, BlockEntityBloodInfuser.class);
        ItemStack tankItem = new ItemStack(RegistryEntries.ITEM_DARK_TANK);
        try (Transaction tx = Transaction.openRoot();){
            ((ResourceHandler)tankItem.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)tankItem))).insert((Resource)FluidResource.of(RegistryEntries.FLUID_BLOOD), 5000, (TransactionContext)tx);
            tx.commit();
        }
        infuser.getInventory().setItem(0, tankItem);
        helper.succeedWhen(() -> {
            helper.assertFalse(infuser.getInventory().getItem(0).isEmpty(), (Component)Component.literal((String)"Container was incorrectly destroyed"));
            helper.assertValueEqual((Object)((ResourceHandler)ItemAccess.forStack((ItemStack)infuser.getInventory().getItem(0)).getCapability(Capabilities.Fluid.ITEM)).getAmountAsInt(0), (Object)0, (Component)Component.literal((String)"Container contents"));
            helper.assertValueEqual((Object)5000, (Object)infuser.getTank().getFluidAmount(), (Component)Component.literal((String)"Blood infuser tank contents"));
        });
    }
}

