/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;

public class GameTestsEntangledChalice {
    public static final String TEMPLATE_EMPTY = "evilcraft:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="evilcraft:empty10")
    public void testEntangledChaliceGroupedFillBlock(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice1 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS, BlockEntityEntangledChalice.class);
        chalice1.setWorldTankId("1");
        helper.setBlock(POS.south().south(), (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice2 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS.south().south(), BlockEntityEntangledChalice.class);
        chalice2.setWorldTankId("1");
        helper.setBlock(POS.south().south().south(), (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice3 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS.south().south().south(), BlockEntityEntangledChalice.class);
        chalice3.setWorldTankId("2");
        ItemStack chaliceItemConnected = new ItemStack((ItemLike)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        chaliceItemConnected.set(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)"1");
        ItemStack chaliceItemDisconnected = new ItemStack((ItemLike)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        chaliceItemDisconnected.set(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)"2");
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_DARK_TANK.get());
        BlockEntityDarkTank tank = (BlockEntityDarkTank)helper.getBlockEntity(POS.above(), BlockEntityDarkTank.class);
        tank.getTank().setFluid(new FluidStack(RegistryEntries.FLUID_BLOOD, 8000));
        tank.setEnabled(true);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)4000, (Object)chalice1.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Original chalice amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)chalice1.getTank().getFluid().getFluid(), (Component)Component.literal((String)"Original chalice fluid type"));
            helper.assertValueEqual((Object)4000, (Object)chalice2.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Connected chalice amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)chalice2.getTank().getFluid().getFluid(), (Component)Component.literal((String)"Connected chalice fluid type"));
            helper.assertValueEqual((Object)0, (Object)chalice3.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Disconnected chalice amount"));
            helper.assertValueEqual((Object)true, (Object)chalice3.getTank().getFluid().isEmpty(), (Component)Component.literal((String)"Disconnected chalice fluid type"));
            ResourceHandler fluidHandler = (ResourceHandler)chaliceItemConnected.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)chaliceItemConnected));
            helper.assertValueEqual((Object)4000, (Object)fluidHandler.getAmountAsInt(0), (Component)Component.literal((String)"Connected chalice item amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)((FluidResource)fluidHandler.getResource(0)).getFluid(), (Component)Component.literal((String)"Connected chalice item fluid type"));
            ResourceHandler fluidHandler2 = (ResourceHandler)chaliceItemDisconnected.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)chaliceItemDisconnected));
            helper.assertValueEqual((Object)0, (Object)fluidHandler2.getAmountAsInt(0), (Component)Component.literal((String)"Disconnected chalice item amount"));
            helper.assertValueEqual((Object)true, (Object)((FluidResource)fluidHandler2.getResource(0)).isEmpty(), (Component)Component.literal((String)"Disconnected chalice item fluid type"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testEntangledChaliceGroupedFillItem(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice1 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS, BlockEntityEntangledChalice.class);
        chalice1.setWorldTankId("1b");
        helper.setBlock(POS.south().south(), (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice2 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS.south().south(), BlockEntityEntangledChalice.class);
        chalice2.setWorldTankId("1b");
        helper.setBlock(POS.south().south().south(), (Block)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        BlockEntityEntangledChalice chalice3 = (BlockEntityEntangledChalice)helper.getBlockEntity(POS.south().south().south(), BlockEntityEntangledChalice.class);
        chalice3.setWorldTankId("2b");
        ItemStack chaliceItemConnected = new ItemStack((ItemLike)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        chaliceItemConnected.set(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)"1b");
        ItemStack chaliceItemDisconnected = new ItemStack((ItemLike)RegistryEntries.BLOCK_ENTANGLED_CHALICE.get());
        chaliceItemDisconnected.set(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)"2b");
        try (Transaction tx = Transaction.openRoot();){
            ((ResourceHandler)chaliceItemConnected.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)chaliceItemConnected))).insert((Resource)FluidResource.of(RegistryEntries.FLUID_BLOOD), 4000, (TransactionContext)tx);
            tx.commit();
        }
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)4000, (Object)chalice1.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Original chalice amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)chalice1.getTank().getFluid().getFluid(), (Component)Component.literal((String)"Original chalice fluid type"));
            helper.assertValueEqual((Object)4000, (Object)chalice2.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Connected chalice amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)chalice2.getTank().getFluid().getFluid(), (Component)Component.literal((String)"Connected chalice fluid type"));
            helper.assertValueEqual((Object)0, (Object)chalice3.getTank().getFluid().getAmount(), (Component)Component.literal((String)"Disconnected chalice amount"));
            helper.assertValueEqual((Object)true, (Object)chalice3.getTank().getFluid().isEmpty(), (Component)Component.literal((String)"Disconnected chalice fluid type"));
            ResourceHandler fluidHandler = (ResourceHandler)chaliceItemConnected.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)chaliceItemConnected));
            helper.assertValueEqual((Object)4000, (Object)fluidHandler.getAmountAsInt(0), (Component)Component.literal((String)"Connected chalice item amount"));
            helper.assertValueEqual((Object)((Fluid)RegistryEntries.FLUID_BLOOD.value()), (Object)((FluidResource)fluidHandler.getResource(0)).getFluid(), (Component)Component.literal((String)"Connected chalice item fluid type"));
            ResourceHandler fluidHandler2 = (ResourceHandler)chaliceItemDisconnected.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)chaliceItemDisconnected));
            helper.assertValueEqual((Object)0, (Object)fluidHandler2.getAmountAsInt(0), (Component)Component.literal((String)"Disconnected chalice item amount"));
            helper.assertValueEqual((Object)true, (Object)((FluidResource)fluidHandler2.getResource(0)).isEmpty(), (Component)Component.literal((String)"Disconnected chalice item fluid type"));
        });
    }
}

