/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;

public class GameTestsVengeanceSpirits {
    public static final String TEMPLATE_EMPTY = "evilcraft:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritCatch(GameTestHelper helper) {
        EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)helper.spawnWithNoFreeWill((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get(), POS.south().south());
        spirit.setInnerEntityType(EntityType.ZOMBIE);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getBottomCenter());
        player.setXRot(-25.0f);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(RegistryEntries.ITEM_VENGEANCE_FOCUS));
        player.getItemInHand(InteractionHand.MAIN_HAND).use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.onEachTick(() -> player.getItemInHand(InteractionHand.MAIN_HAND).onUseTick((Level)helper.getLevel(), (LivingEntity)player, 0));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_BOX_OF_ETERNAL_CLOSURE.value());
        BlockEntityBoxOfEternalClosure box = (BlockEntityBoxOfEternalClosure)helper.getBlockEntity(POS.north(), BlockEntityBoxOfEternalClosure.class);
        helper.succeedWhen(() -> {
            helper.assertTrue(box.hasSpirit(), (Component)Component.literal((String)"Box is empty"));
            helper.assertValueEqual(box.getSpiritData().getInnerEntityType(), (Object)EntityType.ZOMBIE, (Component)Component.literal((String)"Box contains invalid entity type"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritPlayerCatch(GameTestHelper helper) {
        EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)helper.spawnWithNoFreeWill((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get(), POS.south().south());
        spirit.setPlayerId("068d4de0-3a75-4c6a-9f01-8c37e16a394c");
        spirit.setPlayerName("kroeserr");
        spirit.setInnerEntityType(EntityType.ZOMBIE);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getBottomCenter());
        player.setXRot(-25.0f);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(RegistryEntries.ITEM_VENGEANCE_FOCUS));
        player.getItemInHand(InteractionHand.MAIN_HAND).use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.onEachTick(() -> player.getItemInHand(InteractionHand.MAIN_HAND).onUseTick((Level)helper.getLevel(), (LivingEntity)player, 0));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_BOX_OF_ETERNAL_CLOSURE.value());
        BlockEntityBoxOfEternalClosure box = (BlockEntityBoxOfEternalClosure)helper.getBlockEntity(POS.north(), BlockEntityBoxOfEternalClosure.class);
        helper.succeedWhen(() -> {
            helper.assertTrue(box.hasSpirit(), (Component)Component.literal((String)"Box is empty"));
            helper.assertValueEqual((Object)"068d4de0-3a75-4c6a-9f01-8c37e16a394c", (Object)box.getPlayerId(), (Component)Component.literal((String)"Box player id"));
            helper.assertValueEqual((Object)"kroeserr", (Object)box.getPlayerName(), (Component)Component.literal((String)"Box player name"));
            helper.assertValueEqual(box.getSpiritData().getInnerEntityType(), (Object)EntityType.ZOMBIE, (Component)Component.literal((String)"Box contains invalid entity type"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritRelease(GameTestHelper helper) {
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_BOX_OF_ETERNAL_CLOSURE.value());
        BlockEntityBoxOfEternalClosure box = (BlockEntityBoxOfEternalClosure)helper.getBlockEntity(POS.above(), BlockEntityBoxOfEternalClosure.class);
        EntityVengeanceSpirit spiritDummy = new EntityVengeanceSpirit((EntityType<? extends EntityVengeanceSpirit>)((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()), (Level)helper.getLevel());
        spiritDummy.setInnerEntityType(EntityType.ZOMBIE);
        box.captureSpirit(spiritDummy);
        box.closeImmediately();
        helper.getBlockState(POS.above()).useWithoutItem((Level)helper.getLevel(), helper.makeMockPlayer(GameType.SURVIVAL), new BlockHitResult(helper.absolutePos(POS.above()).getCenter(), Direction.DOWN, helper.absolutePos(POS.above()), false));
        helper.succeedWhen(() -> {
            helper.assertFalse(box.hasSpirit(), (Component)Component.literal((String)"Box is not empty"));
            helper.assertEntityPresent((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get());
            EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)((Object)((Object)helper.getEntities((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()).get(0)));
            helper.assertValueEqual(spirit.getInnerEntityType(), (Object)EntityType.ZOMBIE, (Component)Component.literal((String)"Spirit contains invalid entity type"));
        });
    }

    @GameTest(template="evilcraft:empty10", timeoutTicks=200)
    public void testVengeanceSpiritAttack(GameTestHelper helper) {
        EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)helper.spawnWithNoFreeWill((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get(), POS.above().south().south());
        spirit.setInnerEntityType(EntityType.ZOMBIE);
        helper.setBlock(POS.above().south().south().south(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().south().above(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().above().above(), Blocks.STONE);
        helper.setBlock(POS.south().south(), Blocks.STONE);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS.above().above()).getBottomCenter());
        player.setXRot(1.0f);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack(RegistryEntries.ITEM_PIERCING_VENGEANCE_FOCUS));
        player.getItemInHand(InteractionHand.MAIN_HAND).use((Level)helper.getLevel(), player, InteractionHand.MAIN_HAND);
        helper.onEachTick(() -> player.getItemInHand(InteractionHand.MAIN_HAND).onUseTick((Level)helper.getLevel(), (LivingEntity)player, 0));
        helper.succeedWhen(() -> {
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_VENGEANCE_ESSENCE.get());
            helper.assertEntityNotPresent((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get());
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritSpawn(GameTestHelper helper) {
        Zombie zombie = (Zombie)helper.spawnWithNoFreeWill(EntityType.ZOMBIE, POS.above().south());
        zombie.setHealth(1.0f);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getBottomCenter());
        player.setXRot(1.0f);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_SWORD));
        player.getInventory().setItem(0, new ItemStack(RegistryEntries.ITEM_VENGEANCE_RING));
        helper.onEachTick(() -> player.attack((Entity)zombie));
        helper.setBlock(POS.above().south().south().south(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().south().above(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().above().above(), Blocks.STONE);
        helper.setBlock(POS.south().south(), Blocks.STONE);
        helper.succeedWhen(() -> {
            helper.assertEntityNotPresent(EntityType.ZOMBIE);
            helper.assertEntityPresent((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get());
            EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)((Object)((Object)helper.getEntities((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()).get(0)));
            helper.assertValueEqual((Object)spirit.getTarget(), (Object)player, (Component)Component.literal((String)"Spirit targets player"));
            helper.assertValueEqual(spirit.getInnerEntityType(), (Object)EntityType.ZOMBIE, (Component)Component.literal((String)"Spirit contains invalid entity type"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritSpawnWithoutRing(GameTestHelper helper) {
        Zombie zombie = (Zombie)helper.spawnWithNoFreeWill(EntityType.ZOMBIE, POS.above().south());
        zombie.setHealth(1.0f);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(helper.absolutePos(POS).getBottomCenter());
        player.setXRot(1.0f);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_SWORD));
        helper.onEachTick(() -> player.attack((Entity)zombie));
        helper.setBlock(POS.above().south().south().south(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().south().above(), Blocks.STONE);
        helper.setBlock(POS.above().south().south().above().above(), Blocks.STONE);
        helper.setBlock(POS.south().south(), Blocks.STONE);
        helper.succeedWhen(() -> {
            helper.assertEntityNotPresent(EntityType.ZOMBIE);
            helper.assertEntityPresent((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get());
            EntityVengeanceSpirit spirit = (EntityVengeanceSpirit)((Object)((Object)helper.getEntities((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get()).get(0)));
            helper.assertTrue(spirit.getTarget() == null, (Component)Component.literal((String)"Spirit targets nothing"));
            helper.assertValueEqual(spirit.getInnerEntityType(), (Object)EntityType.ZOMBIE, (Component)Component.literal((String)"Spirit contains invalid entity type"));
        });
    }

    @GameTest(template="evilcraft:empty10")
    public void testVengeanceSpiritSpawnNotWhenKilledByNonPlayer(GameTestHelper helper) {
        Zombie zombie = (Zombie)helper.spawnWithNoFreeWill(EntityType.ZOMBIE, POS.above().south());
        zombie.setHealth(1.0f);
        zombie.die(helper.getLevel().damageSources().cactus());
        helper.succeedWhen(() -> {
            helper.assertEntityNotPresent(EntityType.ZOMBIE);
            helper.assertEntityNotPresent((EntityType)RegistryEntries.ENTITY_VENGEANCE_SPIRIT.get());
        });
    }
}

