/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemBiomeExtract;

public class ItemBiomeExtractConfig
extends ItemConfigCommon<IModBase> {
    @ConfigurablePropertyCommon(category="item", comment="If creative versions for all variants should be added to the creative tab.", requiresMcRestart=true)
    public static boolean creativeTabVariants = true;
    @ConfigurablePropertyCommon(category="item", comment="A list of biome names for which no Biome Extracts may be created.")
    public static List<String> craftingBlacklist = Lists.newArrayList();
    @ConfigurablePropertyCommon(category="item", comment="A list of biome names for which no Biome Extracts may be used.")
    public static List<String> usageBlacklist = Lists.newArrayList();

    public ItemBiomeExtractConfig() {
        super((IModBase)EvilCraft._instance, "biome_extract", (eConfig, properties) -> new ItemBiomeExtract((Item.Properties)properties));
        EvilCraft._instance.getModEventBus().addListener(this::onCreativeModeTabBuildContents);
    }

    public static boolean isCraftingBlacklisted(Holder<Biome> biome) {
        return craftingBlacklist.contains(biome.getRegisteredName());
    }

    public static boolean isUsageBlacklisted(Holder<Biome> biome) {
        return usageBlacklist.contains(biome.getRegisteredName());
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void onCreativeModeTabBuildContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == this.getMod().getDefaultCreativeTab()) {
            ArrayList list = Lists.newArrayList();
            list.add(new ItemStack((ItemLike)this.getInstance()));
            if (creativeTabVariants) {
                try {
                    ((ItemBiomeExtract)((Object)this.getInstance())).getBiomes(event.getParameters().holders()).forEach(biome -> list.add(((ItemBiomeExtract)((Object)((Object)this.getInstance()))).createItemStack((Holder<Biome>)biome, 1, (HolderGetter<Biome>)event.getParameters().holders().lookupOrThrow(Registries.BIOME))));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            event.acceptAll((Collection)list);
        }
    }
}

