/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemAccessItemLocation;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.helper.ParticleHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemBloodExtractorConfig;
import org.cyclops.evilcraft.item.ItemVeinSword;
import org.cyclops.evilcraft.item.ItemVeinSwordConfig;

public class ItemBloodExtractor
extends ItemBloodContainer {
    public ItemBloodExtractor(Item.Properties properties) {
        super(properties, ItemBloodExtractorConfig.containerSize);
        this.setPlaceFluids(true);
        NeoForge.EVENT_BUS.addListener(this::bloodObtainEvent);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        if (context.getPlayer().isCrouching() && block instanceof BlockBloodStain) {
            RandomSource random = context.getLevel().random;
            return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)context.getLevel(), context.getClickedPos(), Capabilities.Fluid.BLOCK).map(source -> {
                ItemAccess itemAccess = ItemAccess.forStack((ItemStack)itemStack);
                FluidStack moved = IModHelpersNeoForge.get().getFluidHelpers().move(source, (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)itemAccess), Integer.MAX_VALUE, context.getPlayer(), false, false);
                if (!moved.isEmpty() && context.getLevel().isClientSide()) {
                    ParticleHelpers.spawnBloodSplashParticles(context.getLevel(), context.getClickedPos(), 5, 1 + random.nextInt(2));
                }
                return InteractionResult.SUCCESS.heldItemTransformedTo(itemAccess.getResource().toStack(itemAccess.getAmount()));
            }).orElse((InteractionResult)InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        IModHelpers.get().getL10NHelpers().addStatusInfo(tooltipAdder, ItemHelpers.isActivated(itemStack), this.getDescriptionId() + ".info.auto_supply");
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            return super.use(world, player, hand);
        }
        BlockHitResult target = ItemBloodExtractor.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!(target != null && target.getType() != HitResult.Type.MISS || world.isClientSide())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public static void fillForAllBloodExtractors(Player player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + player.getRandom().nextInt(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            Pair itemStackLocation = it.nextIndexed();
            ItemStack itemStack = (ItemStack)itemStackLocation.getRight();
            if (itemStack.isEmpty() || !(itemStack.getItem() instanceof ItemBloodExtractor)) continue;
            ResourceHandler fluidHandler = (ResourceHandler)new ItemAccessItemLocation(player, new ItemLocation((IInventoryLocation)InventoryLocationPlayer.getInstance(), ((Integer)itemStackLocation.getLeft()).intValue())).getCapability(Capabilities.Fluid.ITEM);
            Transaction tx = Transaction.openRoot();
            try {
                toFill -= fluidHandler.insert((Resource)FluidResource.of(RegistryEntries.FLUID_BLOOD), toFill, (TransactionContext)tx);
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((ResourceHandler<FluidResource>)((ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack))), itemStack, (Level)level, entity, ItemBloodExtractorConfig.autoFillBuckets);
        }
        super.inventoryTick(itemStack, level, entity, slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    public void bloodObtainEvent(LivingDeathEvent event) {
        Entity e = event.getSource().getEntity();
        if (e != null && e instanceof ServerPlayer && !e.level().isClientSide() && event.getEntity() != null) {
            float boost = 1.0f;
            ServerPlayer player = (ServerPlayer)e;
            InteractionHand hand = player.getUsedItemHand();
            if (hand != null && player.getItemInHand(hand) != null && player.getItemInHand(hand).getItem() instanceof ItemVeinSword) {
                boost = (float)ItemVeinSwordConfig.extractionBoost;
            }
            float health = event.getEntity().getMaxHealth();
            int minimumMB = Mth.floor((float)(health * (float)ItemBloodExtractorConfig.minimumMobMultiplier * boost));
            int maximumMB = Mth.floor((float)(health * (float)ItemBloodExtractorConfig.maximumMobMultiplier * boost));
            ItemBloodExtractor.fillForAllBloodExtractors((Player)player, minimumMB, maximumMB);
        }
    }
}

