/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.item.ItemBloodExtractor;

public class ItemBloodExtractorConfig
extends ItemConfigCommon<IModBase> {
    @ConfigurablePropertyCommon(category="item", comment="The minimum multiplier for amount of mB to receive per mob HP.", isCommandable=true)
    public static double minimumMobMultiplier = 5.0;
    @ConfigurablePropertyCommon(category="item", comment="The maximum multiplier for amount of mB to receive per mob HP. IMPORTANT: must be larger than minimumMobMultiplier!", isCommandable=true)
    public static double maximumMobMultiplier = 40.0;
    @ConfigurablePropertyCommon(category="item", comment="The amount of blood (mB) this container can hold.", requiresMcRestart=true)
    public static int containerSize = 5000;
    @ConfigurablePropertyCommon(category="item", comment="If held buckets should be autofilled when enabled.", isCommandable=true)
    public static boolean autoFillBuckets = false;

    public ItemBloodExtractorConfig() {
        super((IModBase)EvilCraft._instance, "blood_extractor", (eConfig, properties) -> new ItemBloodExtractor((Item.Properties)properties));
        EvilCraft._instance.getModEventBus().addListener(this::fillCreativeTab);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        return Collections.emptyList();
    }

    protected void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == EvilCraft._instance.getDefaultCreativeTab()) {
            for (ItemStack itemStack : this.dynamicCreativeTabEntries()) {
                event.accept(itemStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }

    protected Collection<ItemStack> dynamicCreativeTabEntries() {
        return ((ItemBloodExtractor)((Object)this.getInstance())).getDefaultCreativeTabEntries();
    }
}

