/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityItemUndespawnable;
import org.cyclops.evilcraft.item.ItemKineticatorConfig;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public class ItemKineticator
extends ItemBloodContainer {
    private static final int POWER_LEVELS = 5;
    private static final int RANGE_PER_LEVEL = 2;
    private static final double USAGE_PER_D = 0.1;
    private static final int CONTAINER_SIZE = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
    private final boolean repelling;

    public ItemKineticator(Item.Properties properties, boolean repelling) {
        super(properties, CONTAINER_SIZE);
        this.repelling = repelling;
    }

    public boolean isRepelling(ItemStack itemStack) {
        return this.repelling;
    }

    private int getArea(ItemStack itemStack) {
        return 2 * (this.getPower(itemStack) + 1);
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, 5, false) && !world.isClientSide()) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        IModHelpers.get().getL10NHelpers().addStatusInfo(tooltipAdder, ItemHelpers.isActivated(itemStack), this.getDescriptionId() + ".info.attraction");
        tooltipAdder.accept((Component)Component.translatable((String)(this.getDescriptionId() + ".info.area"), (Object[])new Object[]{this.getArea(itemStack)}).withStyle(ChatFormatting.BOLD));
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }

    public void setPower(ItemStack itemStack, int power) {
        ItemPowerableHelpers.setPower(itemStack, power);
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (entity instanceof Player) {
            this.kineticate(itemStack, (Level)level, entity);
        }
        super.inventoryTick(itemStack, level, entity, slot);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        this.kineticate(itemStack, entityItem.level(), (Entity)entityItem);
        return super.onEntityItemUpdate(itemStack, entityItem);
    }

    private void kineticate(ItemStack itemStack, Level world, Entity entity) {
        if (ItemHelpers.isActivated(itemStack) && (!FluidUtil.getFirstStackContained((ItemStack)itemStack).isEmpty() || entity instanceof Player && this.canConsume(1, itemStack, (Player)entity)) && entity != null && !entity.isCrouching()) {
            ResourceHandler fluidHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack));
            boolean repelling = this.isRepelling(itemStack);
            boolean isPlayer = entity instanceof Player;
            double x = entity.getX();
            double y = entity.getY();
            double z = entity.getZ();
            if (0L == world.getGameTime() % (long)ItemKineticatorConfig.tickHoldoff) {
                int area = this.getArea(itemStack);
                AABB box = new AABB(x, y, z, x, y, z).inflate((double)area);
                List entities = world.getEntities(entity, box, (Predicate)new com.google.common.base.Predicate<Entity>(this){

                    public boolean apply(Entity entity) {
                        return entity instanceof ItemEntity || ItemKineticatorConfig.moveXP && entity instanceof ExperienceOrb;
                    }
                });
                for (Entity moveEntity : entities) {
                    if (!repelling && (!(moveEntity instanceof ItemEntity) || ((ItemEntity)moveEntity).hasPickUpDelay() || !this.canKineticateItem(((ItemEntity)moveEntity).getItem())) && !(moveEntity instanceof ExperienceOrb)) continue;
                    double dx = moveEntity.getX() - x;
                    double dy = moveEntity.getY() - (isPlayer ? y + (double)(world.isClientSide() ? -1 : 1) : y);
                    double dz = moveEntity.getZ() - z;
                    double strength = -0.3;
                    if (isPlayer) {
                        strength = -1.0;
                    }
                    if (repelling) {
                        strength /= -1.0;
                        if (isPlayer) {
                            strength = 0.3;
                        }
                    }
                    double d = Mth.sqrt((float)((float)(dx * dx + dy * dy + dz * dz)));
                    int usage = (int)Math.round(d * 0.1);
                    if (!repelling && !(d > 0.5) || usage != 0 && !this.canDrain((ResourceHandler<FluidResource>)fluidHandler, usage) && (!isPlayer || !this.canConsume(usage, itemStack, (Player)entity))) continue;
                    double m = 1.0 / (2.0 * Math.max(1.0, d));
                    dx *= m;
                    dy *= m;
                    dz *= m;
                    if (world.isClientSide()) {
                        this.showEntityMoved(world, entity, moveEntity, dx / 10.0, dy / 10.0, dz / 10.0);
                    } else {
                        if (moveEntity instanceof ItemEntity && d < 5.0) {
                            ((ItemEntity)moveEntity).setPickUpDelay(repelling ? 5 : 0);
                        }
                        moveEntity.setDeltaMovement(new Vec3(dx, dy, dz).multiply(strength, strength, strength));
                        if (moveEntity.horizontalCollision) {
                            moveEntity.setDeltaMovement(new Vec3(moveEntity.getDeltaMovement().x, 0.3, moveEntity.getDeltaMovement().z));
                        }
                    }
                    if (0L != world.getGameTime() % (long)ItemKineticatorConfig.consumeHoldoff) continue;
                    if (isPlayer) {
                        this.consume(usage, itemStack, (Player)entity);
                        continue;
                    }
                    try (Transaction tx = Transaction.openRoot();){
                        fluidHandler.extract((Resource)((FluidResource)fluidHandler.getResource(0)), usage, (TransactionContext)tx);
                        tx.commit();
                    }
                }
            }
        }
    }

    protected boolean canDrain(ResourceHandler<FluidResource> fluidHandler, int usage) {
        try (Transaction tx = Transaction.openRoot();){
            boolean bl = fluidHandler.extract((Resource)((FluidResource)fluidHandler.getResource(0)), usage, (TransactionContext)tx) > 0;
            return bl;
        }
    }

    protected boolean canKineticateItem(ItemStack entityItem) {
        if (entityItem == null) {
            return false;
        }
        return !ItemKineticatorConfig.kineticateBlacklist.contains(BuiltInRegistries.ITEM.getKey((Object)entityItem.getItem()).toString());
    }

    protected void showEntityMoved(Level world, Entity player, Entity entity, double dx, double dy, double dz) {
        RandomSource rand = world.random;
        float scale = 0.05f;
        float red = rand.nextFloat() * 0.03f + 0.5f;
        float green = rand.nextFloat() * 0.03f + (rand.nextBoolean() ? 0.5f : 0.3f);
        float blue = rand.nextFloat() * 0.05f;
        float ageMultiplier = (float)(rand.nextDouble() * 2.5 + 10.0);
        world.addParticle((ParticleOptions)new ParticleBlurData(red, green, blue, scale, ageMultiplier), entity.getX(), entity.getY(), entity.getZ(), -dx, -dy, -dz);
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemStack) {
        return new EntityItemUndespawnable(world, (ItemEntity)location);
    }
}

