/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.client.particle.ParticleBlurTargettedEntityData;
import org.cyclops.evilcraft.client.particle.ParticleDistortData;
import org.cyclops.evilcraft.client.particle.ParticleExplosionExtendedData;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemPowerableHelpers;

public abstract class ItemMace
extends ItemBloodContainer {
    private final int hitUsage;
    private final int maximumCharge;
    private final int powerLevels;
    private final float meleeDamage;

    public ItemMace(Item.Properties builder, int containerSize, int hitUsage, int maximumCharge, int powerLevels, float meleeDamage) {
        super(builder, containerSize);
        this.hitUsage = hitUsage;
        this.maximumCharge = maximumCharge;
        this.powerLevels = powerLevels;
        this.meleeDamage = meleeDamage;
    }

    protected boolean isUsable(ItemStack itemStack, Player player) {
        return this.canConsume(1, itemStack, player);
    }

    public void hurtEnemy(ItemStack itemStack, LivingEntity attacked, LivingEntity attacker) {
        if (attacker instanceof Player && this.isUsable(itemStack, (Player)attacker)) {
            try (Transaction tx = Transaction.openRoot();){
                ((ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack))).extract((Resource)FluidResource.of((Fluid)this.getFluid()), this.hitUsage, (TransactionContext)tx);
                tx.commit();
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack itemStack, Player player, Entity entity) {
        return !this.isUsable(itemStack, player);
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return this.maximumCharge * (this.powerLevels - this.getPower(itemStack));
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (ItemPowerableHelpers.onPowerableItemItemRightClick(itemStack, world, player, this.powerLevels, true)) {
            return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
        }
        if (this.isUsable(itemStack, player)) {
            player.startUsingItem(hand);
            return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
        }
        if (world.isClientSide()) {
            this.animateOutOfEnergy(world, (LivingEntity)player);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack itemStack, int duration) {
        Level world = player.level();
        if (world.isClientSide() && duration % 2 == 0) {
            this.showUsingItemTick(world, itemStack, player, duration);
        }
        super.onUseTick(level, player, itemStack, duration);
    }

    protected void showUsingItemTick(Level world, ItemStack itemStack, LivingEntity entity, int duration) {
        int itemUsedCount = this.getUseDuration(itemStack, entity) - duration;
        double area = this.getArea(itemUsedCount);
        int points = (int)Math.pow(area, 0.55) * 2 + 1;
        int particleChance = 5 * (this.powerLevels - this.getPower(itemStack));
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            for (double pointHeight = (double)(-points); pointHeight <= (double)points; pointHeight += 0.5) {
                if (world.random.nextInt(particleChance) != 0) continue;
                double u = Math.PI * (point / (double)points);
                double v = Math.PI * -2 * (pointHeight / (double)points);
                double xOffset = Math.cos(u) * Math.sin(v) * area;
                double yOffset = Math.sin(u) * area;
                double zOffset = Math.cos(v) * area;
                double xCoord = entity.getX();
                double yCoord = entity.getY() + (double)entity.getEyeHeight() - (Minecraft.getInstance().player == entity ? 0.5 : 1.5);
                double zCoord = entity.getZ();
                double particleX = xCoord + xOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                double particleY = yCoord + yOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                double particleZ = zCoord + zOffset - (double)world.random.nextFloat() * area / 4.0 - 0.5;
                float particleMotionX = (float)(xOffset * 10.0);
                float particleMotionY = (float)(yOffset * 10.0);
                float particleMotionZ = (float)(zOffset * 10.0);
                world.addParticle((ParticleOptions)new ParticleDistortData((float)area * 3.0f), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
                if (world.random.nextInt(10) != 0) continue;
                int spread = 10;
                float scale2 = 0.3f - world.random.nextFloat() * 0.2f;
                float r = 1.0f * world.random.nextFloat();
                float g = 0.2f + 0.01f * world.random.nextFloat();
                float b = 0.1f + 0.5f * world.random.nextFloat();
                float ageMultiplier2 = 20.0f;
                double motionX = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                double motionY = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                double motionZ = (double)spread - world.random.nextDouble() * 2.0 * (double)spread;
                world.addParticle((ParticleOptions)new ParticleBlurTargettedEntityData(r, g, b, scale2, ageMultiplier2, entity.getId()), particleX, particleY, particleZ, motionX, motionY, motionZ);
            }
        }
    }

    protected void showUsedItemTick(Level world, LivingEntity player, int power) {
        int particles = (power + 1) * (power + 1) * (power + 1) * 10;
        for (int i = 0; i < particles; ++i) {
            double x = player.getX() - 0.5 + world.random.nextDouble();
            double y = player.getY() + (double)player.getEyeHeight() - 1.0 + world.random.nextDouble();
            double z = player.getZ() - 0.5 + world.random.nextDouble();
            double particleMotionX = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionY = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            double particleMotionZ = (-1.0 + world.random.nextDouble() * 2.0) * (double)(power + 1) / 2.0;
            float r = 1.0f * world.random.nextFloat();
            float g = 0.2f + 0.01f * world.random.nextFloat();
            float b = 0.1f + 0.5f * world.random.nextFloat();
            world.addParticle((ParticleOptions)new ParticleExplosionExtendedData(r, g, b, 0.3f), x, y, z, particleMotionX, particleMotionY, particleMotionZ);
        }
    }

    protected double getArea(int itemUsedCount) {
        return (double)(itemUsedCount / 5) + 2.0;
    }

    public boolean releaseUsing(ItemStack itemStack, Level world, LivingEntity entity, int itemInUseCount) {
        if (entity instanceof Player) {
            IFluidHandlerCapacity fluidHandler = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(ItemAccess.forStack((ItemStack)itemStack)).orElse(null);
            Player player = (Player)entity;
            int itemUsedCount = this.getUseDuration(itemStack, entity) - itemInUseCount;
            int toDrain = itemUsedCount * fluidHandler.getTankCapacity(0) * (this.getPower(itemStack) + 1) / (this.getUseDuration(itemStack, entity) * this.powerLevels);
            FluidStack consumed = this.consume(toDrain, itemStack, player);
            int consumedAmount = consumed == null ? 0 : consumed.getAmount();
            itemUsedCount = consumedAmount * this.getUseDuration(itemStack, entity) / fluidHandler.getTankCapacity(0);
            if (consumedAmount > 0) {
                this.use(world, entity, itemUsedCount, this.getPower(itemStack));
                if (world.isClientSide()) {
                    this.showUsedItemTick(world, entity, this.getPower(itemStack));
                }
            } else if (world.isClientSide()) {
                this.animateOutOfEnergy(world, entity);
            }
            return true;
        }
        return false;
    }

    protected abstract void use(Level var1, LivingEntity var2, int var3, int var4);

    protected void animateOutOfEnergy(Level world, LivingEntity entity) {
        double xCoord = entity.getX();
        double yCoord = entity.getY();
        double zCoord = entity.getZ();
        float particleMotionX = world.random.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.random.nextFloat() * 0.2f - 0.1f;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack itemStack) {
        return new ItemAttributeModifiers((List)Lists.newArrayList((Object[])new ItemAttributeModifiers.Entry[]{new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"add_mace_damage"), (double)this.meleeDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)}));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        ItemPowerableHelpers.addPreInformation(itemStack, tooltipAdder);
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        ItemPowerableHelpers.addPostInformation(itemStack, tooltipAdder);
    }

    public int getPower(ItemStack itemStack) {
        return ItemPowerableHelpers.getPower(itemStack);
    }
}

