/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemStack;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.inventory.container.ContainerPrimedPendant;
import org.cyclops.evilcraft.item.ItemPrimedPendantConfig;

public class ItemPrimedPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = IModHelpers.get().getMinecraftHelpers().getSecondInTicks() / 2;

    public ItemPrimedPendant(Item.Properties properties) {
        super(properties, ItemPrimedPendantConfig.capacity);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        PotionContents contents;
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        ItemStack potionStack = this.getPotionStack(itemStack);
        if (!potionStack.isEmpty() && (contents = (PotionContents)potionStack.get(DataComponents.POTION_CONTENTS)) != null) {
            List potionEffects = contents.customEffects();
            for (MobEffectInstance potionEffect : potionEffects) {
                MutableComponent textComponent = Component.translatable((String)(super.getDescriptionId() + ".potion"), (Object[])new Object[]{Component.translatable((String)potionEffect.getDescriptionId()), Component.translatable((String)("enchantment.level." + (potionEffect.getAmplifier() + 1)))});
                Double multiplier = ItemPrimedPendantConfig.getMultiplier((Holder<MobEffect>)potionEffect.getEffect());
                if (multiplier != null && multiplier < 0.0) {
                    textComponent.withStyle(ChatFormatting.STRIKETHROUGH);
                }
                tooltipAdder.accept((Component)textComponent);
            }
        }
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (entity instanceof Player) {
            PotionContents contents;
            ItemStack potionStack;
            Player player = (Player)entity;
            if (level.getGameTime() % (long)TICK_MODULUS == 0L && !(potionStack = this.getPotionStack(itemStack)).isEmpty() && (contents = (PotionContents)potionStack.get(DataComponents.POTION_CONTENTS)) != null) {
                ArrayList potionEffects = Lists.newArrayList((Iterable)contents.customEffects());
                contents.potion().ifPresent(potionHolder -> {
                    Potion potion = (Potion)potionHolder.value();
                    potionEffects.addAll(potion.getEffects());
                });
                for (MobEffectInstance potionEffect : potionEffects) {
                    int toDrain = ItemPrimedPendantConfig.usage * (potionEffect.getAmplifier() + 1);
                    Double multiplier = ItemPrimedPendantConfig.getMultiplier((Holder<MobEffect>)potionEffect.getEffect());
                    if (multiplier != null) {
                        toDrain = (int)((double)toDrain * multiplier);
                    }
                    if (multiplier != null && !(multiplier >= 0.0) || !this.canConsume(toDrain, itemStack, player)) continue;
                    player.addEffect(new MobEffectInstance(potionEffect.getEffect(), TICK_MODULUS * 27, potionEffect.getAmplifier(), potionEffect.isAmbient(), true));
                    this.consume(toDrain, itemStack, player);
                }
            }
        }
        super.inventoryTick(itemStack, level, entity, slot);
    }

    public boolean hasPotionStack(ItemStack itemStack) {
        return !this.getPotionStack(itemStack).isEmpty();
    }

    public ItemStack getPotionStack(ItemStack itemStack) {
        Container inventory = this.getSupplementaryInventory(ItemAccess.forStack((ItemStack)itemStack));
        return inventory.getItem(0);
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.hasPotionStack(itemStack);
    }

    public Container getSupplementaryInventory(Player player, ItemLocation itemLocation) {
        return new NBTSimpleInventoryItemHeld(player, itemLocation, 1, 64, "inventoryItem");
    }

    public Container getSupplementaryInventory(ItemAccess itemAccess) {
        return new NBTSimpleInventoryItemStack(itemAccess, 1, 64, "inventoryItem");
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).getHoverName(), ContainerPrimedPendant::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerPrimedPendant.class;
    }

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.isEmpty() && player instanceof ServerPlayer && player.containerMenu != null && player.containerMenu.getClass() == this.getContainerClass(player.level(), player, itemstack)) {
            player.closeContainer();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openScreenForItemIndex(Level world, ServerPlayer player, ItemLocation itemLocation) {
        MenuProvider containerProvider;
        if (!world.isClientSide() && (containerProvider = this.getContainer(world, (Player)player, itemLocation)) != null) {
            player.openMenu(containerProvider, packetBuffer -> this.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, itemLocation));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.awardStat(openStat);
            }
        }
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, ItemLocation itemLocation) {
        ItemLocation.writeToPacketBuffer((FriendlyByteBuf)packetBuffer, (ItemLocation)itemLocation);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        if (player instanceof ServerPlayer) {
            this.openScreenForItemIndex(world, (ServerPlayer)player, InventoryLocationPlayer.getInstance().handToLocation(player, hand, player.getInventory().getSelectedSlot()));
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }
}

