/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;

public class LootFunctionCopyTankData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyTankData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyTankData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyTankData::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyTankData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        Object object = lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof BlockEntityTankInventory) {
            BlockEntityTankInventory tile = (BlockEntityTankInventory)((Object)object);
            SingleUseTank fluidHandlerTile = tile.getTank();
            ItemAccess itemAccess = ItemAccess.forStack((ItemStack)itemStack);
            return Optional.ofNullable((ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM)).map(fluidHandlerItem -> {
                try (Transaction tx = Transaction.openRoot();){
                    fluidHandlerItem.insert((Resource)((FluidResource)fluidHandlerTile.getResource(0)), fluidHandlerTile.getFluidAmount(), (TransactionContext)tx);
                    if (fluidHandlerItem instanceof IFluidHandlerCapacity) {
                        ((IFluidHandlerCapacity)fluidHandlerItem).setTankCapacity(0, fluidHandlerTile.getTankCapacity(0));
                    }
                    tx.commit();
                }
                return itemAccess.getResource().toStack(itemAccess.getAmount());
            }).orElse(itemStack);
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

