/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.advancement.criterion.FartTrigger;
import org.cyclops.evilcraft.client.particle.ParticleFartData;

public class FartPacket
extends PlayerPositionPacket<FartPacket> {
    public static final CustomPacketPayload.Type<FartPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"fart"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FartPacket> CODEC = FartPacket.getCodec(FartPacket::new);
    private static final int MAX_PARTICLES = 200;
    private static final int MIN_PARTICLES = 100;
    private static final float CLIENT_PLAYER_Y_OFFSET = -0.8f;
    private static final float REMOTE_PLAYER_Y_OFFSET = 0.65f;
    private static final List<UUID> ALLOW_RAINBOW_FARTS = new ArrayList<UUID>();

    public FartPacket() {
        super(ID);
    }

    public FartPacket(Player player) {
        super(ID, player);
    }

    public void actionClient(Level world, Player player) {
        if (GeneralConfig.farting) {
            super.actionClient(world, player);
        }
    }

    protected void performClientAction(Level world, Player player) {
        this.spawnFartParticles(world, player, this.position, true);
    }

    private void spawnFartParticles(Level world, Player player, Vec3 pos, boolean isClientSidePlayer) {
        if (player == null) {
            return;
        }
        RandomSource rand = world.random;
        int numParticles = rand.nextInt(100) + 100;
        boolean rainbow = this.hasRainbowFart(player);
        double yaw = (double)player.getYRot() * Math.PI / 180.0;
        double playerXOffset = Math.sin(yaw) * 0.7;
        double playerZOffset = -Math.cos(yaw) * 0.7;
        float playerYOffset = isClientSidePlayer ? 0.65f : -0.8f;
        for (int i = 0; i < numParticles; ++i) {
            double extraDistance = (double)rand.nextFloat() % 0.3;
            double particleX = pos.x + playerXOffset + extraDistance;
            double particleY = pos.y + (double)playerYOffset;
            double particleZ = pos.z + playerZOffset + extraDistance;
            float particleMotionX = -0.5f + rand.nextFloat();
            float particleMotionY = -0.5f + rand.nextFloat();
            float particleMotionZ = -0.5f + rand.nextFloat();
            world.addParticle((ParticleOptions)new ParticleFartData(rainbow), particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    public boolean hasRainbowFart(Player player) {
        return player.getGameProfile() != null && ALLOW_RAINBOW_FARTS.contains(player.getGameProfile().id());
    }

    public void actionServer(Level world, ServerPlayer player) {
        if (GeneralConfig.farting) {
            ((FartTrigger)((Object)RegistryEntries.TRIGGER_FART.get())).test(player);
            super.actionServer(world, player);
        }
    }

    protected PlayerPositionPacket create(Player player, int range) {
        return new FartPacket(player);
    }

    protected IModBase getModInstance() {
        return EvilCraft._instance;
    }

    static {
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("068d4de0-3a75-4c6a-9f01-8c37e16a394c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("e1dc75c6-dcf9-4e0c-8fbf-9c6e5e44527c"));
        ALLOW_RAINBOW_FARTS.add(UUID.fromString("777e7aa3-9373-4511-8d75-f99d23ebe252"));
    }
}

