/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.model.data.ModelProperty;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class BlockDarkTank
extends BlockWithEntity
implements IBlockTank {
    public static final MapCodec<BlockDarkTank> CODEC = BlockDarkTank.simpleCodec(BlockDarkTank::new);
    public static final ModelProperty<FluidStack> TANK_FLUID = new ModelProperty();
    public static final ModelProperty<Integer> TANK_CAPACITY = new ModelProperty();
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.016f, (double)2.0, (double)14.0, (double)15.984f, (double)14.0);

    public BlockDarkTank(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDarkTank::new);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockDarkTank.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DARK_TANK.get()), (BlockEntityTicker)new BlockEntityDarkTank.TickerServer());
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos) {
        BlockEntityTankInventory tile = (BlockEntityTankInventory)world.getBlockEntity(blockPos);
        float output = (float)tile.getTank().getFluidAmount() / (float)tile.getTank().getCapacity();
        return (int)Math.ceil((float)IModHelpers.get().getMinecraftHelpers().getComparatorMultiplier() * output);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)worldIn, (BlockPos)pos, (Direction)Direction.UP)) {
            return InteractionResult.SUCCESS;
        }
        if (!player.isCrouching()) {
            IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)worldIn, pos, BlockEntityDarkTank.class).ifPresent(tile -> {
                tile.setEnabled(!tile.isEnabled());
                player.displayClientMessage((Component)Component.literal((String)String.format(Locale.ROOT, "%,d", tile.getTank().getFluidAmount())).append(" / ").append(String.format(Locale.ROOT, "%,d", tile.getTank().getCapacity())).append(" mB"), true);
            });
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, worldIn, pos, player, hand, pHitResult);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return IModHelpers.get().getBlockEntityHelpers().get(world, pos, BlockEntityDarkTank.class).map(tile -> tile.getTank().getFluidType() != null ? (int)Math.min(15.0, tile.getFillRatio() * (double)tile.getTank().getFluidType().getFluidType().getLightLevel(tile.getTank().getFluid()) * 15.0) : 0).orElse(0);
    }

    @Override
    public int getDefaultCapacity() {
        return 16000;
    }

    @Override
    public boolean isActivatable() {
        return true;
    }

    @Override
    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.isCrouching()) {
            if (!world.isClientSide()) {
                ItemStack activated = itemStack.copy();
                ItemHelpers.toggleActivation(activated);
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    @Override
    public boolean isActivated(ItemStack itemStack, Item.TooltipContext context) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void fillItemCategory(NonNullList<ItemStack> list) {
        int lastCapacity;
        int capacityOriginal;
        ItemStack itemStack = new ItemStack((ItemLike)this);
        int capacity = capacityOriginal = 16000;
        do {
            IFluidHandlerItemCapacity fluidHandler = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(itemStack.copy()).orElse(null);
            fluidHandler.setCapacity(capacity);
            list.add((Object)fluidHandler.getContainer().copy());
            fluidHandler.fill(new FluidStack(RegistryEntries.FLUID_BLOOD, capacity), IFluidHandler.FluidAction.EXECUTE);
            list.add((Object)fluidHandler.getContainer().copy());
            lastCapacity = capacity;
        } while ((capacity <<= 2) < BlockDarkTankConfig.maxTankCreativeSize && capacity > lastCapacity);
        if (BlockDarkTankConfig.creativeTabFluids) {
            for (Fluid fluid : BuiltInRegistries.FLUID) {
                if (fluid == RegistryEntries.FLUID_BLOOD.get() || !fluid.isSource(fluid.defaultFluidState())) continue;
                try {
                    ItemStack itemStackFilled = itemStack.copy();
                    IFluidHandlerItemCapacity fluidHandlerFilled = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(itemStackFilled).orElse(null);
                    fluidHandlerFilled.setCapacity(capacityOriginal);
                    fluidHandlerFilled.fill(new FluidStack(fluid, capacityOriginal), IFluidHandler.FluidAction.EXECUTE);
                    list.add((Object)fluidHandlerFilled.getContainer());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }
}

