/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.FluidContainerItemTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.InfuseItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.recipe.type.InventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;

public class BlockEntityBloodInfuser
extends BlockEntityWorking<BlockEntityBloodInfuser, MutableInt>
implements MenuProvider {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static final int LIQUID_PER_SLOT = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 10;
    public static Metadata METADATA = new Metadata();
    private int infuseTicker = this.addTicker(new TickComponent<BlockEntityBloodInfuser, ITickAction<BlockEntityBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private SingleCache<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>> recipeCache;
    private float xp;
    private static final Multimap<Class<?>, ITickAction<BlockEntityBloodInfuser>> INFUSE_TICK_ACTIONS = LinkedListMultimap.create();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_FILLBLOODPERTICK;

    public BlockEntityBloodInfuser(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_INFUSER.get(), blockPos, blockState, 3, 64, LIQUID_PER_SLOT, (Fluid)RegistryEntries.FLUID_BLOOD.get());
        this.addTicker(new TickComponent<BlockEntityBloodInfuser, ITickAction<BlockEntityBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntityBloodInfuser, MutableInt>(this, 2.0){

            @Override
            public void applyUpgrade(BlockEntityBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntityBloodInfuser, MutableInt>(this, 1.0){

            @Override
            public void applyUpgrade(BlockEntityBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_FILLBLOODPERTICK) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val * (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                } else if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>>(){

            public Optional<RecipeBloodInfuser> getNewValue(Triple<ItemStack, Integer, Integer> key) {
                InventoryFluidTier recipeInput = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), (NonNullList<FluidStack>)NonNullList.of((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{new FluidStack(RegistryEntries.FLUID_BLOOD, ((Integer)key.getMiddle()).intValue())}), (Integer)key.getRight());
                return ((ServerLevel)BlockEntityBloodInfuser.this.level).recipeAccess().recipeMap().getRecipesFor(BlockEntityBloodInfuser.this.getRegistry(), (RecipeInput)recipeInput, BlockEntityBloodInfuser.this.getLevel()).map(RecipeHolder::value).max(Comparator.comparingInt(r -> r.getInputTier().orElse(0)));
            }

            public boolean isKeyEqual(Triple<ItemStack, Integer, Integer> cacheKey, Triple<ItemStack, Integer, Integer> newKey) {
                return cacheKey == null || newKey == null || ItemStack.matches((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && ((Integer)cacheKey.getMiddle()).equals(newKey.getMiddle()) && ((Integer)cacheKey.getRight()).equals(newKey.getRight());
            }
        });
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this);
    }

    @Override
    public void saveAdditional(ValueOutput valueOutput) {
        valueOutput.putFloat("xp", this.xp);
        super.saveAdditional(valueOutput);
    }

    @Override
    public void read(ValueInput valueInput) {
        this.xp = valueInput.getFloatOr("xp", 0.0f);
        super.read(valueInput);
    }

    public Direction getRotation() {
        return ((Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(this.getBlockState(), BlockBloodInfuser.FACING, (Comparable)Direction.NORTH)).getOpposite();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public Optional<RecipeBloodInfuser> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)Triple.of((Object)(itemStack.isEmpty() ? ItemStack.EMPTY : itemStack.copy()), (Object)this.getTank().getFluidAmount(), (Object)this.getTileWorkingMetadata().getTier((Container)this.getInventory())));
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockBloodInfuser.ON, (Comparable)Boolean.valueOf(this.isWorking())));
        IModHelpers.get().getBlockHelpers().markForUpdate(this.getLevel(), this.getBlockPos());
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    protected int getWorkTicker() {
        return this.infuseTicker;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, net.minecraft.world.entity.player.Inventory playerInventory, Player playerEntity) {
        return new ContainerBloodInfuser(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public RecipeType<RecipeBloodInfuser> getRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.evilcraft.blood_infuser");
    }

    public void setXp(float xp) {
        this.xp = xp;
        this.setChanged();
    }

    public float getXp() {
        return this.xp;
    }

    public void addXp(float xp) {
        this.setXp(this.getXp() + xp);
    }

    public void resetXp() {
        this.setXp(0.0f);
    }

    static {
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_FILLBLOODPERTICK = Upgrades.newUpgradeEventType();
    }

    public static class Inventory
    extends BlockEntityWorking.Inventory<BlockEntityBloodInfuser> {
        public Inventory(int size, int stackLimit, BlockEntityBloodInfuser tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return ((BlockEntityBloodInfuser)this.tile).getTileWorkingMetadata().canConsume(itemStack, ((BlockEntityBloodInfuser)this.tile).getLevel());
            }
            if (slot == 0) {
                return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)((Fluid)RegistryEntries.FLUID_BLOOD.get()));
            }
            return super.canPlaceItem(slot, itemStack);
        }
    }

    public static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(3);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            Optional fluidHandler;
            if (!itemStack.isEmpty() && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack.copy().split(1))).isPresent()) {
                return true;
            }
            return true;
        }

        @Override
        public boolean canInsertItem(Container inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        protected Block getBlock() {
            return (Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get();
        }

        public int getConsumeSlot() {
            return 1;
        }

        public int getProduceSlot() {
            return 2;
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityWorking.CapabilityRegistrar<BlockEntityBloodInfuser, MutableInt> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityBloodInfuser>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int slot = 0;
                if (direction == Direction.UP) {
                    slot = 1;
                }
                if (direction == Direction.DOWN) {
                    slot = 2;
                }
                return new ItemHandlerSlotMasked((Container)blockEntity.getInventory(), new int[]{slot});
            });
        }
    }
}

