/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.fluid.FluidHandlerWrapper;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodStain;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestal;
import org.cyclops.evilcraft.block.BlockSanguinaryPedestalConfig;
import org.cyclops.evilcraft.core.algorithm.RegionIterator;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.network.packet.SanguinaryPedestalBlockReplacePacket;

public class BlockEntitySanguinaryPedestal
extends BlockEntityTankInventory {
    private static final int MB_RATE = 100;
    public static final int TANK_BUCKETS = 10;
    private static final int OFFSET = 2;
    private static final int OFFSET_EFFICIENCY = 4;
    private static final int ACTIONS_PER_TICK_EFFICIENCY = 5;
    private final IFluidHandler bonusFluidHandler = new FluidHandlerWrapper((IFluidHandler)this.getTank()){

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntitySanguinaryPedestal.this.hasEfficiency() && !resource.isEmpty()) {
                resource.setAmount((int)((double)resource.getAmount() * BlockSanguinaryPedestalConfig.efficiencyBoost));
            }
            return super.fill(resource, action);
        }
    };
    private RegionIterator regionIterator;

    public BlockEntitySanguinaryPedestal(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SANGUINARY_PEDESTAL.get(), blockPos, blockState, 0, 1, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 10, (Fluid)RegistryEntries.FLUID_BLOOD.get());
    }

    public IFluidHandler getBonusFluidHandler() {
        return this.bonusFluidHandler;
    }

    protected void afterBlockReplace(ServerLevel world, BlockPos location) {
        EvilCraft._instance.getPacketHandler().sendToAllAroundPoint((PacketBase)new SanguinaryPedestalBlockReplacePacket(location.getX(), location.getY(), location.getZ()), IPacketHandler.createTargetPointFromLocation((ServerLevel)world, (BlockPos)location, (int)15));
    }

    protected boolean hasEfficiency() {
        return ((BlockSanguinaryPedestal)this.getBlockState().getBlock()).getTier() == 1;
    }

    private BlockPos getNextLocation() {
        if (this.regionIterator == null) {
            this.regionIterator = new RegionIterator(this.getBlockPos(), this.hasEfficiency() ? 4 : 2, true);
        }
        return this.regionIterator.next();
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntitySanguinaryPedestal> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySanguinaryPedestal blockEntity) {
            int actions;
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            int n = actions = blockEntity.hasEfficiency() ? 5 : 1;
            while (!blockEntity.getTank().isFull() && actions > 0) {
                BlockPos location = blockEntity.getNextLocation();
                Block block = level.getBlockState(location).getBlock();
                if (block instanceof BlockBloodStain) {
                    IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, location, Capabilities.FluidHandler.BLOCK).ifPresent(source -> {
                        FluidStack moved = FluidUtil.tryFluidTransfer((IFluidHandler)blockEntity.getBonusFluidHandler(), (IFluidHandler)source, (int)Integer.MAX_VALUE, (boolean)true);
                        if (!moved.isEmpty()) {
                            blockEntity.afterBlockReplace((ServerLevel)level, location);
                        }
                    });
                }
                --actions;
            }
            if (!blockEntity.getTank().isEmpty()) {
                for (Direction direction : Direction.values()) {
                    IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(direction), (Object)direction.getOpposite(), Capabilities.FluidHandler.BLOCK).ifPresent(handler -> {
                        FluidStack fluidStack;
                        if (!blockEntity.getTank().isEmpty() && handler.fill(fluidStack = new FluidStack(blockEntity.getTank().getFluid().getFluid(), Math.min(100, blockEntity.getTank().getFluidAmount())), IFluidHandler.FluidAction.SIMULATE) > 0) {
                            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            blockEntity.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityTankInventory.CapabilityRegistrar<BlockEntitySanguinaryPedestal> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySanguinaryPedestal>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void registerTankInventoryCapabilitiesItem() {
        }
    }
}

