/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.Block;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntitySanguinaryEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.client.gui.container.ContainerScreenTileWorking;
import org.cyclops.evilcraft.inventory.container.ContainerSanguinaryEnvironmentalAccumulator;

public class ContainerScreenSanguinaryEnvironmentalAccumulator
extends ContainerScreenTileWorking<ContainerSanguinaryEnvironmentalAccumulator, BlockEntitySanguinaryEnvironmentalAccumulator> {
    public static final int TEXTUREWIDTH = 176;
    public static final int TEXTUREHEIGHT = 166;
    public static final int PROGRESSWIDTH = 24;
    public static final int PROGRESSHEIGHT = 16;
    public static final int PROGRESSX = 192;
    public static final int PROGRESSY = 0;
    public static final int PROGRESSTARGETX = 77;
    public static final int PROGRESSTARGETY = 36;
    public static final int PROGRESS_INVALIDX = 192;
    public static final int PROGRESS_INVALIDY = 18;

    public ContainerScreenSanguinaryEnvironmentalAccumulator(ContainerSanguinaryEnvironmentalAccumulator container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.setProgress(24, 16, 192, 0, 77, 36);
    }

    @Override
    protected Component getName() {
        return Component.translatable((String)"block.evilcraft.sanguinary_environmental_accumulator");
    }

    @Override
    protected void drawAdditionalForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawAdditionalForeground(guiGraphics, mouseX, mouseY);
        String prefix = ((Block)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get()).getDescriptionId() + ".help.invalid";
        ArrayList lines = Lists.newArrayList();
        lines.add(Component.translatable((String)prefix));
        if (!((ContainerSanguinaryEnvironmentalAccumulator)this.getMenu()).getTileCanWork()) {
            lines.add(Component.translatable((String)(prefix + ".invalid_locations")));
            for (Vec3i location : ((ContainerSanguinaryEnvironmentalAccumulator)this.getMenu()).getInvalidLocations()) {
                lines.add(Component.literal((String)String.format("  X=%s Y=%s Z=%s", location.getX(), location.getY(), location.getZ())));
            }
        }
        if (lines.size() > 1) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getGuiTexture(), 77 + this.offsetX, 36 + this.offsetY, 192.0f, 18.0f, 24, 16, 256, 256);
            if (this.isHovering(77 + this.offsetX, 36 + this.offsetY, 24, 16, mouseX, mouseY)) {
                this.drawTooltip(lines, guiGraphics, mouseX -= this.leftPos, mouseY -= this.topPos);
            }
        }
    }

    public ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/sanguinary_environmental_accumulator_gui.png");
    }
}

