/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.client.render.model.ModelBroomPartBaked;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.jetbrains.annotations.Nullable;

public record ItemModelBroomPart(List<ItemTintSource> tints, ModelBroomPartBaked model, ModelRenderProperties modelRenderProperties) implements ItemModel
{
    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        new BlockModelWrapper(this.tints, this.model.handleItemState(stack, (Level)level, entity), this.modelRenderProperties).update(renderState, stack, itemModelResolver, displayContext, level, entity, seed);
    }

    public record Unbaked(List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"broom_part");
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)builder, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public ItemModel bake(ItemModel.BakingContext bakingContext) {
            ModelBaker baker = bakingContext.blockModelBaker();
            IdentityHashMap broomPartModels = Maps.newIdentityHashMap();
            for (IBroomPart part : BroomParts.REGISTRY.getParts()) {
                broomPartModels.put(part, ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (ResourceLocation)BroomParts.REGISTRY.getPartModel(part), (ModelState)BlockModelRotation.X0_Y0));
            }
            return new ItemModelBroomPart(this.tints, new ModelBroomPartBaked(broomPartModels), new ModelRenderProperties(false, null, ModelHelpers.DEFAULT_CAMERA_TRANSFORMS));
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            for (ResourceLocation partModel : BroomParts.REGISTRY.getPartModels()) {
                resolver.markDependency(partModel);
            }
        }
    }
}

