/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.jetbrains.annotations.Nullable;

public class ModelBroomPartBaked
extends DynamicItemAndBlockModel {
    private final Map<IBroomPart, BlockStateModel> broomPartModels;
    private final RandomSource rand = RandomSource.create();

    public ModelBroomPartBaked(Map<IBroomPart, BlockStateModel> broomPartModels) {
        super(true, false);
        this.broomPartModels = broomPartModels;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        throw new UnsupportedOperationException();
    }

    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return null;
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of(ChunkSectionLayer.values());
    }

    public List<BakedQuad> handleItemState(@javax.annotation.Nullable ItemStack itemStack, @javax.annotation.Nullable Level world, @javax.annotation.Nullable LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        Object part = BroomParts.REGISTRY.getPartFromItem(itemStack);
        BlockStateModel model = this.broomPartModels.get(part);
        if (model != null) {
            for (BlockModelPart blockModelPart : model.collectParts(this.rand)) {
                quads.addAll(this.color(blockModelPart.getQuads(null), part.getModelColor()));
            }
        }
        return quads;
    }

    private Collection<? extends BakedQuad> color(List<BakedQuad> quads, int color) {
        ArrayList offsetQuads = Lists.newArrayListWithExpectedSize((int)quads.size());
        for (BakedQuad quad : quads) {
            int[] vertexData = Arrays.copyOf(quad.vertices(), quad.vertices().length);
            for (int i = 0; i < vertexData.length / 8; ++i) {
                vertexData[i * 8 + 3] = color;
            }
            offsetQuads.add(new BakedQuad(vertexData, quad.tintIndex(), quad.direction(), quad.sprite(), false, quad.lightEmission(), quad.hasAmbientOcclusion()));
        }
        return offsetQuads;
    }

    public TextureAtlasSprite particleIcon() {
        return null;
    }

    public UnbakedModel wrapped() {
        return null;
    }

    @Nullable
    public ResolvedModel parent() {
        return null;
    }

    public ItemTransforms getTopTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS;
    }

    public String debugName() {
        return "evilcraft:broom_part";
    }
}

