/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.TriState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;

public class BlockTankHelpers {
    private BlockTankHelpers() {
    }

    public static MutableComponent getInfoTank(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        int amount = fluidStack.getAmount();
        int capacity = FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> ((IFluidHandlerItemCapacity)handler).getCapacity()).orElse(0);
        return DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity).withStyle(IInformationProvider.ITEM_PREFIX);
    }

    public static ItemStack tileDataToItemStack(BlockEntity tile, ItemStack itemStack) {
        IFluidHandler fluidHandlerTile = (IFluidHandler)tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), null, tile, null);
        if (fluidHandlerTile != null) {
            FluidActionResult res;
            IFluidHandlerItem fluidHandlerItem;
            IFluidHandlerItemCapacity fluidHandlerItemCapacity = (IFluidHandlerItemCapacity)itemStack.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY);
            if (fluidHandlerItemCapacity != null && fluidHandlerTile instanceof IFluidTank) {
                IFluidTank fluidTank = (IFluidTank)fluidHandlerTile;
                fluidHandlerItemCapacity.setCapacity(fluidTank.getCapacity());
                itemStack = fluidHandlerItemCapacity.getContainer();
            }
            if ((fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)) != null && (res = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fluidHandlerTile, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                itemStack = res.getResult();
            }
        }
        return itemStack;
    }

    public static void itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        IFluidHandler fluidHandlerTile = (IFluidHandler)tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), null, tile, null);
        if (fluidHandlerTile != null) {
            IFluidHandlerItem fluidHandlerItem;
            IFluidHandlerItemCapacity fluidHandlerItemCapacity = (IFluidHandlerItemCapacity)itemStack.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY);
            if (fluidHandlerItemCapacity != null && fluidHandlerTile instanceof FluidTank) {
                FluidTank fluidTank = (FluidTank)fluidHandlerTile;
                fluidTank.setCapacity(fluidHandlerItemCapacity.getCapacity());
            }
            if ((fluidHandlerItem = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)fluidHandlerTile, (int)Integer.MAX_VALUE, null, (boolean)true);
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().isEmpty() && event.getItemStack().getCapability(Capabilities.FluidHandler.ITEM) != null && event.getLevel().getBlockState(event.getPos()).getBlock() instanceof IBlockTank) {
            event.setUseBlock(TriState.TRUE);
        }
    }

    static {
        NeoForge.EVENT_BUS.register((Object)new BlockTankHelpers());
    }

    public static class SimulatableTankWrapper
    implements IFluidHandler {
        private final IFluidHandler tank;

        public SimulatableTankWrapper(IFluidHandler tank) {
            this.tank = tank;
        }

        public int getTanks() {
            return this.tank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.tank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.tank.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack drained = this.tank.drain(resource, action);
            return action.execute() ? drained : FluidContainerItemWrapperWithSimulation.asSimulatedFluidStack(new FluidStack(drained.getFluid(), drained.getAmount()));
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = this.tank.drain(maxDrain, action);
            return action.execute() ? drained : FluidContainerItemWrapperWithSimulation.asSimulatedFluidStack(new FluidStack(drained.getFluid(), drained.getAmount()));
        }

        public boolean isFull() {
            for (int i = 0; i < this.tank.getTanks(); ++i) {
                if (this.tank.getFluidInTank(i).getAmount() >= this.tank.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.tank.getTanks(); ++i) {
                if (this.tank.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

