/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemDefinedRotation;

public class EntityItemDarkStick
extends EntityItemDefinedRotation {
    private static final EntityDataAccessor<Integer> WATCHERID_VALID = SynchedEntityData.defineId(EntityItemDarkStick.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> WATCHERID_ANGLE = SynchedEntityData.defineId(EntityItemDarkStick.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private double lastPosX = -1.0;
    private double lastPosY = -1.0;
    private double lastPosZ = -1.0;
    private boolean loadedAngle = false;

    public EntityItemDarkStick(EntityType<? extends EntityItemDarkStick> type, Level world) {
        super((EntityType<? extends EntityItemDefinedRotation>)type, world);
    }

    public EntityItemDarkStick(Level world, ItemEntity original) {
        super((EntityType<? extends EntityItemDefinedRotation>)((EntityType)RegistryEntries.ENTITY_ITEM_DARK_STICK.get()), world, original);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WATCHERID_VALID, (Object)0);
        builder.define(WATCHERID_ANGLE, (Object)Float.valueOf(0.0f));
    }

    protected boolean hasMoved() {
        boolean moved = Math.abs(this.lastPosX - this.getX()) > (double)0.1f || Math.abs(this.lastPosZ - this.getZ()) > (double)0.1f;
        this.lastPosX = this.getX();
        this.lastPosY = this.getY();
        this.lastPosZ = this.getZ();
        return moved;
    }

    public void tick() {
        super.tick();
        if (!(this.level().isClientSide() || !this.hasMoved() && this.loadedAngle)) {
            this.loadedAngle = true;
            Float angle = this.loadRotation();
            this.setValid(angle != null);
            this.setAngle(angle == null ? 0.0f : angle.floatValue());
        }
    }

    @Nullable
    private Float loadRotation() {
        Registry registry = this.level().registryAccess().lookupOrThrow(Registries.STRUCTURE);
        HolderSet holderset = (HolderSet)registry.get(RegistryEntries.STRUCTURE_DARK_TEMPLE.getKey()).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElseThrow();
        Pair closestHolder = ((ServerLevel)this.level()).getChunkSource().getGenerator().findNearestMapStructure((ServerLevel)this.level(), holderset, BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), 100, false);
        if (closestHolder != null) {
            BlockPos closest = new BlockPos(((BlockPos)closestHolder.getFirst()).getX(), 0, ((BlockPos)closestHolder.getFirst()).getZ());
            double d = closest.distSqr((Vec3i)new BlockPos((int)this.getX(), 0, (int)this.getZ()));
            if (d <= (double)(IModHelpers.get().getWorldHelpers().getChunkSize() * IModHelpers.get().getWorldHelpers().getChunkSize())) {
                return null;
            }
            BlockPos normalized = new BlockPos(closest.getX() - (int)this.getX(), 0, closest.getZ() - (int)this.getZ());
            return Float.valueOf((float)(Math.atan2(normalized.getX(), normalized.getZ()) * 180.0 / Math.PI));
        }
        return null;
    }

    @Override
    protected boolean hasCustomRotation() {
        return this.isValid();
    }

    public float getAngle() {
        return ((Float)this.entityData.get(WATCHERID_ANGLE)).floatValue();
    }

    protected void setAngle(float angle) {
        this.entityData.set(WATCHERID_ANGLE, (Object)Float.valueOf(angle));
    }

    public boolean isValid() {
        return (Integer)this.entityData.get(WATCHERID_VALID) == 1;
    }

    protected void setValid(boolean valid) {
        this.entityData.set(WATCHERID_VALID, (Object)(valid ? 1 : 0));
    }
}

