/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public abstract class ItemAbstractFocus
extends Item {
    private static final int TICK_MODULUS = 3;

    public ItemAbstractFocus(Item.Properties properties) {
        super(properties);
    }

    private int getItemInUseDuration(LivingEntity player) {
        return Math.max(0, player.getTicksUsingItem() - player.getUseItemRemainingTicks());
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.getItemInUseDuration((LivingEntity)player) > 0) {
            return InteractionResult.FAIL;
        }
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return Integer.MAX_VALUE;
    }

    public boolean releaseUsing(ItemStack itemStack, Level world, LivingEntity player, int duration) {
        if (this.getItemInUseDuration(player) > 6) {
            if (player.level().isClientSide()) {
                player.playSound((SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_STOP.get(), 0.6f + player.level().random.nextFloat() * 0.2f, 1.0f);
            }
            return true;
        }
        return false;
    }

    protected abstract ThrowableProjectile newBeamEntity(LivingEntity var1);

    public void onUseTick(Level level, LivingEntity player, ItemStack itemStack, int remaining) {
        int duration = this.getUseDuration(itemStack, player) - remaining;
        if (duration > 6) {
            if (IModHelpers.get().getWorldHelpers().efficientTick(player.level(), 3, new int[]{player.getId()})) {
                ThrowableProjectile beam = this.newBeamEntity(player);
                if (!player.level().isClientSide()) {
                    beam.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.5f, 1.0f);
                    player.level().addFreshEntity((Entity)beam);
                }
            }
        } else if (duration == 3 && player.level().isClientSide()) {
            player.playSound((SoundEvent)RegistryEntries.SOUNDEVENT_EFFECT_VENGEANCEBEAM_START.get(), 0.6f + player.level().random.nextFloat() * 0.2f, 1.0f);
        }
    }
}

