/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodStain;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.helper.ParticleHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;

public class ItemCreativeBloodDrop
extends ItemBloodContainer {
    public static final int MB_FILL_PERTICK = 1000;

    public ItemCreativeBloodDrop(Item.Properties properties) {
        super(properties, 1000);
        this.setPlaceFluids(true);
    }

    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        IModHelpers.get().getL10NHelpers().addStatusInfo(tooltipAdder, ItemHelpers.isActivated(itemStack), this.getDescriptionId() + ".info.auto_supply");
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        ItemCreativeBloodDrop.updateAutoFill(itemStack, (Level)level, entity);
        super.inventoryTick(itemStack, level, entity, slot);
    }

    public static void updateAutoFill(ItemStack itemStack, Level world, Entity entity) {
        FluidStack tickFluid;
        IFluidHandler source = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        if (source != null && entity instanceof Player && !world.isClientSide() && ItemHelpers.isActivated(itemStack) && (tickFluid = source.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)) != null && tickFluid.getAmount() > 0) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.getItemInHand(hand);
                IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)held).orElse(null);
                if (held.isEmpty() || held == itemStack || fluidHandler == null || player.getUseItemRemainingTicks() != 0 || fluidHandler.fill(tickFluid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                int filled = fluidHandler.fill(new FluidStack(tickFluid.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
                source.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getBarWidth(ItemStack itemStack) {
        return 13;
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.getPlayer().isCrouching()) {
            BlockPos pos = context.getClickedPos().offset(0, 1, 0);
            if (((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState().canSurvive((LevelReader)context.getLevel(), pos)) {
                if (context.getLevel().isClientSide()) {
                    ParticleHelpers.spawnBloodSplashParticles(context.getLevel(), pos, 5, 1 + context.getLevel().random.nextInt(2));
                } else {
                    if (context.getLevel().isEmptyBlock(pos)) {
                        context.getLevel().setBlockAndUpdate(pos, ((Block)RegistryEntries.BLOCK_BLOOD_STAIN.get()).defaultBlockState());
                    }
                    if (context.getLevel().getBlockState(pos).getBlock() == RegistryEntries.BLOCK_BLOOD_STAIN.get()) {
                        IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)context.getLevel(), pos, BlockEntityBloodStain.class).ifPresent(tile -> tile.addAmount(IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume()));
                    }
                }
                return InteractionResult.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            return super.use(world, player, hand);
        }
        BlockHitResult target = ItemCreativeBloodDrop.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!(target != null && target.getType() != HitResult.Type.MISS || world.isClientSide())) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemStack);
    }
}

